/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.AbstractProfileInterceptorAction;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectProfileInterceptorFlow
extends AbstractProfileInterceptorAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectProfileInterceptorFlow.class);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        if (!super.doPreExecute(profileRequestContext, interceptorContext)) {
            return false;
        }
        if (interceptorContext.getAttemptedFlow() != null) {
            this.log.debug("{} Moving completed flow {} to completed set, selecting next one", (Object)this.getLogPrefix(), (Object)interceptorContext.getAttemptedFlow().getId());
            interceptorContext.getAvailableFlows().remove(interceptorContext.getAttemptedFlow().getId());
            interceptorContext.setAttemptedFlow(null);
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        ProfileInterceptorFlowDescriptor flow = this.selectUnattemptedFlow(profileRequestContext, interceptorContext);
        if (flow == null) {
            this.log.debug("{} No flows available to choose from", (Object)this.getLogPrefix());
            return;
        }
        this.log.debug("{} Selecting flow {}", (Object)this.getLogPrefix(), (Object)flow.getId());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)flow.getId());
    }

    @Nullable
    private ProfileInterceptorFlowDescriptor selectUnattemptedFlow(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        for (ProfileInterceptorFlowDescriptor flow : interceptorContext.getAvailableFlows().values()) {
            this.log.debug("{} Checking flow {} for applicability...", (Object)this.getLogPrefix(), (Object)flow.getId());
            if (flow.apply(profileRequestContext)) {
                interceptorContext.setAttemptedFlow(flow);
                return flow;
            }
            this.log.debug("{} Flow {} was not applicable to this request", (Object)this.getLogPrefix(), (Object)flow.getId());
        }
        return null;
    }
}

