/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.audit.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import net.shibboleth.idp.profile.audit.impl.PopulateAuditContext;
import net.shibboleth.idp.profile.context.AuditContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateAuditContextTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private PopulateAuditContext action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.action = new PopulateAuditContext();
    }

    @Test
    public void testSingle() throws Exception {
        HashMap<String, MockFunction> map = new HashMap<String, MockFunction>();
        map.put("a", new MockFunction(Collections.singletonList("foo")));
        this.action.setFieldExtractors(map);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuditContext ac = (AuditContext)this.prc.getSubcontext(AuditContext.class);
        Assert.assertNotNull((Object)ac);
        Assert.assertEquals((int)ac.getFieldValues("a").size(), (int)1);
        Assert.assertEquals((String)((String)ac.getFieldValues("a").iterator().next()), (String)"foo");
        Assert.assertTrue((boolean)ac.getFieldValues("b").isEmpty());
        this.action = new PopulateAuditContext();
        this.action.setFieldExtractors(map);
        this.action.initialize();
        event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ac = (AuditContext)this.prc.getSubcontext(AuditContext.class);
        Assert.assertNotNull((Object)ac);
        Assert.assertEquals((int)ac.getFieldValues("a").size(), (int)1);
        Assert.assertEquals((String)((String)ac.getFieldValues("a").iterator().next()), (String)"foo");
        this.action = new PopulateAuditContext();
        this.action.setClearAuditContext(true);
        this.action.initialize();
        event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ac = (AuditContext)this.prc.getSubcontext(AuditContext.class);
        Assert.assertNotNull((Object)ac);
        Assert.assertTrue((boolean)ac.getFields().isEmpty());
    }

    @Test
    public void testMultiple() throws Exception {
        HashMap<String, MockFunction> map = new HashMap<String, MockFunction>();
        map.put("a", new MockFunction(Collections.singletonList("foo")));
        map.put("A", new MockFunction(Arrays.asList("bar", "baz")));
        this.action.setFieldExtractors(map);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuditContext ac = (AuditContext)this.prc.getSubcontext(AuditContext.class);
        Assert.assertNotNull((Object)ac);
        Assert.assertEquals((int)ac.getFieldValues("a").size(), (int)1);
        Assert.assertEquals((String)((String)ac.getFieldValues("a").iterator().next()), (String)"foo");
        Assert.assertTrue((boolean)ac.getFieldValues("b").isEmpty());
        Assert.assertEquals((int)ac.getFieldValues("A").size(), (int)2);
        Assert.assertEquals((Object[])ac.getFieldValues("A").toArray(), (Object[])new String[]{"bar", "baz"});
    }

    @Test
    public void testSkipped() throws Exception {
        HashMap<String, MockFunction> map = new HashMap<String, MockFunction>();
        map.put("a", new MockFunction(Collections.singletonList("foo")));
        map.put("A", new MockFunction(Arrays.asList("bar", "baz")));
        this.action.setFieldExtractors(map);
        this.action.setFormattingMapParser(new PopulateAuditContext.FormattingMapParser(Collections.singletonMap("foo", "%A - %b %%")));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuditContext ac = (AuditContext)this.prc.getSubcontext(AuditContext.class);
        Assert.assertNotNull((Object)ac);
        Assert.assertTrue((boolean)ac.getFieldValues("a").isEmpty());
        Assert.assertTrue((boolean)ac.getFieldValues("b").isEmpty());
        Assert.assertEquals((int)ac.getFieldValues("A").size(), (int)2);
        Assert.assertEquals((Object[])ac.getFieldValues("A").toArray(), (Object[])new String[]{"bar", "baz"});
    }

    private class MockFunction
    implements Function<ProfileRequestContext, Object> {
        private Collection<String> result;

        public MockFunction(Collection<String> arg) {
            this.result = arg;
        }

        @Override
        public Collection<String> apply(ProfileRequestContext input) {
            return this.result;
        }
    }
}

