/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.util.Collections;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.impl.SelectProfileConfiguration;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.MockProfileConfiguration;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SelectProfileConfigurationTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private SelectProfileConfiguration action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig(null);
        this.action = new SelectProfileConfiguration();
        this.action.initialize();
    }

    @Test
    public void testNoRelyingPartyContext() throws Exception {
        this.prc.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyContext");
    }

    @Test
    public void testNoRelyingPartyConfiguration() throws Exception {
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setConfiguration(null);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyConfiguration");
    }

    @Test
    public void testInvalidProfileConfiguration() throws Exception {
        this.src = new RequestContextBuilder().setRelyingPartyProfileConfigurations(Collections.singleton(new MockProfileConfiguration("mock"))).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig(null);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
        Assert.assertNull((Object)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getProfileConfig());
    }

    @Test
    public void testInvalidProfileConfigurationNoFail() throws Exception {
        this.action = new SelectProfileConfiguration();
        this.action.setFailIfMissing(false);
        this.action.initialize();
        this.src = new RequestContextBuilder().setRelyingPartyProfileConfigurations(Collections.singleton(new MockProfileConfiguration("mock"))).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig(null);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getProfileConfig());
    }

    @Test
    public void testSelectProfileConfiguration() throws Exception {
        this.src = new RequestContextBuilder().setRelyingPartyProfileConfigurations(Collections.singleton(new MockProfileConfiguration("mock"))).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig(null);
        this.prc.setProfileId("mock");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getProfileConfig());
        Assert.assertEquals((String)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getProfileConfig().getId(), (String)"mock");
    }

    @Test
    public void testFallback() throws Exception {
        this.src = new RequestContextBuilder().setRelyingPartyProfileConfigurations(Collections.singleton(new MockProfileConfiguration("mock"))).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig(null);
        this.prc.setProfileId("new");
        this.prc.setLegacyProfileId("mock");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getProfileConfig());
        Assert.assertEquals((String)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getProfileConfig().getId(), (String)"mock");
        Assert.assertEquals((String)this.prc.getProfileId(), (String)"mock");
    }
}

