/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.impl.SelectRelyingPartyConfiguration;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.Resolver;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SelectRelyingPartyConfigurationTest {
    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoResolver() throws ComponentInitializationException {
        SelectRelyingPartyConfiguration action = new SelectRelyingPartyConfiguration();
        action.initialize();
    }

    @Test
    public void testNoRelyingPartyContext() throws Exception {
        RequestContext src = new RequestContextBuilder().buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(src);
        prc.removeSubcontext(RelyingPartyContext.class);
        MockResolver resolver = new MockResolver(null, null);
        SelectRelyingPartyConfiguration action = new SelectRelyingPartyConfiguration();
        action.setRelyingPartyConfigurationResolver((Resolver)resolver);
        action.initialize();
        Event event = action.execute(src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyContext");
    }

    @Test
    public void testNoRelyingPartyConfiguration() throws Exception {
        RequestContext src = new RequestContextBuilder().buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(src);
        ((RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class)).setConfiguration(null);
        MockResolver resolver = new MockResolver(null, null);
        SelectRelyingPartyConfiguration action = new SelectRelyingPartyConfiguration();
        action.setRelyingPartyConfigurationResolver((Resolver)resolver);
        action.initialize();
        Event event = action.execute(src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyConfiguration");
    }

    @Test
    public void testUnableToResolveRelyingPartyConfiguration() throws Exception {
        RequestContext src = new RequestContextBuilder().buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(src);
        ((RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class)).setConfiguration(null);
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setDetailedErrors(true);
        config.initialize();
        MockResolver resolver = new MockResolver(config, new ResolverException());
        SelectRelyingPartyConfiguration action = new SelectRelyingPartyConfiguration();
        action.setRelyingPartyConfigurationResolver((Resolver)resolver);
        action.initialize();
        Event event = action.execute(src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyConfiguration");
    }

    @Test
    public void testResolveRelyingPartyConfiguration() throws Exception {
        RequestContext src = new RequestContextBuilder().buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(src);
        ((RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class)).setConfiguration(null);
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setDetailedErrors(true);
        config.initialize();
        MockResolver resolver = new MockResolver(config, null);
        SelectRelyingPartyConfiguration action = new SelectRelyingPartyConfiguration();
        action.setRelyingPartyConfigurationResolver((Resolver)resolver);
        action.initialize();
        Event event = action.execute(src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RelyingPartyConfiguration resolvedConfig = ((RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class)).getConfiguration();
        Assert.assertEquals((String)resolvedConfig.getId(), (String)config.getId());
        Assert.assertEquals((String)resolvedConfig.getResponderId(prc), (String)config.getResponderId(prc));
        Assert.assertEquals((Map)resolvedConfig.getProfileConfigurations(prc), (Map)config.getProfileConfigurations(prc));
    }

    private class MockResolver
    extends AbstractIdentifiedInitializableComponent
    implements RelyingPartyConfigurationResolver {
        private RelyingPartyConfiguration configuration;
        private ResolverException exception;

        public MockResolver(@Nullable RelyingPartyConfiguration relyingPartyConfiguration, ResolverException resolverException) {
            this.configuration = relyingPartyConfiguration;
            this.exception = resolverException;
        }

        public Iterable<RelyingPartyConfiguration> resolve(ProfileRequestContext context) throws ResolverException {
            if (this.exception != null) {
                throw this.exception;
            }
            return Collections.singleton(this.configuration);
        }

        public RelyingPartyConfiguration resolveSingle(ProfileRequestContext context) throws ResolverException {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.configuration;
        }

        public SecurityConfiguration getDefaultSecurityConfiguration(String profileId) {
            return null;
        }
    }
}

