/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.interceptor.impl.FilterFlowsByNonBrowserSupport;
import net.shibboleth.idp.profile.interceptor.impl.PopulateProfileInterceptorContextTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FilterFlowsByNonBrowserSupportTest
extends PopulateProfileInterceptorContextTest {
    private FilterFlowsByNonBrowserSupport action;

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.action = new FilterFlowsByNonBrowserSupport();
        this.action.initialize();
    }

    @Test
    public void testBrowserProfile() {
        ProfileInterceptorContext interceptorCtx = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        this.prc.setBrowserProfile(true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)interceptorCtx.getAvailableFlows().size(), (int)3);
    }

    @Test
    public void testNoFiltering() {
        ProfileInterceptorContext interceptorCtx = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)interceptorCtx.getAvailableFlows().size(), (int)3);
    }

    @Test
    public void testPartialFiltering() {
        ProfileInterceptorContext interceptorCtx = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        ((ProfileInterceptorFlowDescriptor)interceptorCtx.getAvailableFlows().get("intercept/test1")).setNonBrowserSupported(false);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)interceptorCtx.getAvailableFlows().size(), (int)2);
        Assert.assertNotNull(interceptorCtx.getAvailableFlows().get("intercept/test2"));
        Assert.assertNotNull(interceptorCtx.getAvailableFlows().get("intercept/test3"));
    }
}

