/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.interceptor.impl.PopulateProfileInterceptorContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateProfileInterceptorContextTest {
    protected List<ProfileInterceptorFlowDescriptor> interceptorFlows;
    protected RequestContext src;
    protected ProfileRequestContext prc;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.interceptorFlows = List.of(new ProfileInterceptorFlowDescriptor(), new ProfileInterceptorFlowDescriptor(), new ProfileInterceptorFlowDescriptor());
        this.interceptorFlows.get(0).setId("intercept/test1");
        this.interceptorFlows.get(1).setId("intercept/test2");
        this.interceptorFlows.get(2).setId("intercept/test3");
        PopulateProfileInterceptorContext action = new PopulateProfileInterceptorContext();
        action.setAvailableFlows(this.interceptorFlows);
        action.setActiveFlowsLookupStrategy(FunctionSupport.constant(Arrays.asList("test1", "test2", "test3")));
        action.initialize();
        Event event = action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testAction() throws Exception {
        ProfileInterceptorContext interceptorContext = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        Assert.assertNotNull((Object)interceptorContext);
        List availableFlows = List.copyOf(interceptorContext.getAvailableFlows().values());
        Assert.assertEquals((int)availableFlows.size(), (int)3);
        Assert.assertEquals((String)((ProfileInterceptorFlowDescriptor)availableFlows.get(0)).getId(), (String)"intercept/test1");
        Assert.assertEquals((String)((ProfileInterceptorFlowDescriptor)availableFlows.get(1)).getId(), (String)"intercept/test2");
        Assert.assertEquals((String)((ProfileInterceptorFlowDescriptor)availableFlows.get(2)).getId(), (String)"intercept/test3");
    }

    @Test
    public void testError() throws Exception {
        PopulateProfileInterceptorContext action = new PopulateProfileInterceptorContext();
        action.setAvailableFlows(this.interceptorFlows);
        action.setActiveFlowsLookupStrategy(FunctionSupport.constant(Collections.singletonList("test4")));
        action.initialize();
        Event event = action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }
}

