/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.interceptor.impl.PopulateProfileInterceptorContextTest;
import net.shibboleth.idp.profile.interceptor.impl.SelectProfileInterceptorFlow;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SelectProfileInterceptorFlowTest
extends PopulateProfileInterceptorContextTest {
    private SelectProfileInterceptorFlow action;
    private ProfileInterceptorContext interceptorCtx;

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.action = new SelectProfileInterceptorFlow();
        this.action.initialize();
        this.interceptorCtx = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
    }

    @Test
    public void testSelect() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"intercept/test1");
        Assert.assertEquals((Object)this.interceptorCtx.getAttemptedFlow(), this.interceptorCtx.getAvailableFlows().get("intercept/test1"));
        Assert.assertEquals((String)this.interceptorCtx.getAttemptedFlow().getId(), (String)event.getId());
    }

    @Test
    public void testIncompleteFlows() {
        this.action.execute(this.src);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"intercept/test2");
        Assert.assertEquals((Object)this.interceptorCtx.getAttemptedFlow(), this.interceptorCtx.getAvailableFlows().get("intercept/test2"));
        Assert.assertEquals((String)this.interceptorCtx.getAttemptedFlow().getId(), (String)event.getId());
    }

    @Test
    public void testPredicate() {
        ((ProfileInterceptorFlowDescriptor)this.interceptorCtx.getAvailableFlows().get("intercept/test1")).setActivationCondition((Predicate)Predicates.alwaysFalse());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"intercept/test2");
        Assert.assertEquals((Object)this.interceptorCtx.getAttemptedFlow(), this.interceptorCtx.getAvailableFlows().get("intercept/test2"));
        Assert.assertEquals((String)this.interceptorCtx.getAttemptedFlow().getId(), (String)event.getId());
    }
}

