/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.support;

import java.util.Arrays;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.profile.support.PathInfoSupportingFlowUrlHandler;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PathInfoSupportingFlowUrlHandlerTest {
    MockHttpServletRequest request;
    PathInfoSupportingFlowUrlHandler handler;

    @BeforeMethod
    public void setUp() {
        this.request = new MockHttpServletRequest();
        this.handler = new PathInfoSupportingFlowUrlHandler();
    }

    @Test
    public void testNoPathInfo() {
        Assert.assertNull((Object)this.handler.getFlowId((HttpServletRequest)this.request));
    }

    @Test
    public void testNoneSupported() {
        this.request.setPathInfo("/admin/foo/bar/baz");
        Assert.assertEquals((String)"admin/foo/bar/baz", (String)this.handler.getFlowId((HttpServletRequest)this.request));
    }

    @Test
    public void testNoMatch() {
        this.request.setPathInfo("/admin/foo/bar/baz");
        this.handler.setSupportedFlows(Collections.singletonList("admit/fop"));
        Assert.assertEquals((String)"admin/foo/bar/baz", (String)this.handler.getFlowId((HttpServletRequest)this.request));
    }

    @Test
    public void testSuported() {
        this.request.setPathInfo("/admin/foo/bar/baz");
        this.handler.setSupportedFlows(Collections.singletonList("admin/foo/bar"));
        Assert.assertEquals((String)"admin/foo/bar", (String)this.handler.getFlowId((HttpServletRequest)this.request));
        this.handler.setSupportedFlows(Collections.singletonList("admin/foo"));
        Assert.assertEquals((String)"admin/foo", (String)this.handler.getFlowId((HttpServletRequest)this.request));
    }

    @Test
    public void testOverlapping() {
        this.request.setPathInfo("/admin/foo/bar/baz");
        this.handler.setSupportedFlows(Arrays.asList("admin/foo/bar", "admin/foo", "admin"));
        Assert.assertEquals((String)"admin/foo/bar", (String)this.handler.getFlowId((HttpServletRequest)this.request));
        this.handler.setSupportedFlows(Arrays.asList("admin", "admin/foo", "admin/foo/bar"));
        Assert.assertEquals((String)"admin", (String)this.handler.getFlowId((HttpServletRequest)this.request));
    }
}

