/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty.impl;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.relyingparty.impl.DefaultRelyingPartyConfigurationResolver;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultRelyingPartyConfigurationResolverTest {
    @Test
    public void testConstruction() throws ComponentInitializationException {
        RelyingPartyConfiguration one = new RelyingPartyConfiguration();
        one.setId("one");
        one.setResponderId("foo");
        one.setDetailedErrors(true);
        one.initialize();
        RelyingPartyConfiguration two = new RelyingPartyConfiguration();
        two.setId("two");
        two.setResponderId("foo");
        two.setDetailedErrors(true);
        two.setActivationCondition((Predicate)Predicates.alwaysFalse());
        two.initialize();
        RelyingPartyConfiguration three = new RelyingPartyConfiguration();
        three.setId("three");
        three.setResponderId("foo");
        three.setDetailedErrors(true);
        three.initialize();
        List<RelyingPartyConfiguration> rpConfigs = Arrays.asList(one, two, three);
        DefaultRelyingPartyConfigurationResolver resolver = new DefaultRelyingPartyConfigurationResolver();
        resolver.setId("test");
        resolver.setRelyingPartyConfigurations(rpConfigs);
        Assert.assertEquals((String)resolver.getId(), (String)"test");
        Assert.assertEquals((int)resolver.getRelyingPartyConfigurations().size(), (int)3);
        resolver = new DefaultRelyingPartyConfigurationResolver();
        resolver.setId("test");
        Assert.assertEquals((String)resolver.getId(), (String)"test");
        Assert.assertEquals((int)resolver.getRelyingPartyConfigurations().size(), (int)0);
        resolver = new DefaultRelyingPartyConfigurationResolver();
        resolver.setId("test");
        Assert.assertEquals((String)resolver.getId(), (String)"test");
        Assert.assertEquals((int)resolver.getRelyingPartyConfigurations().size(), (int)0);
    }

    @Test
    public void testDefault() throws Exception {
        ProfileRequestContext requestContext = new ProfileRequestContext();
        ((RelyingPartyContext)requestContext.getSubcontext(RelyingPartyContext.class, true)).setVerified(Boolean.valueOf(true));
        RelyingPartyConfiguration anonRP = new RelyingPartyConfiguration();
        anonRP.setId("anonRPId");
        anonRP.setResponderId("anonRPResp");
        anonRP.setDetailedErrors(true);
        anonRP.initialize();
        RelyingPartyConfiguration defaultRP = new RelyingPartyConfiguration();
        defaultRP.setId("defaultRPId");
        defaultRP.setResponderId("defaultRPResp");
        defaultRP.setDetailedErrors(true);
        defaultRP.initialize();
        DefaultRelyingPartyConfigurationResolver resolver = new DefaultRelyingPartyConfigurationResolver();
        resolver.setId("test");
        resolver.setUnverifiedConfiguration(anonRP);
        resolver.setDefaultConfiguration(defaultRP);
        resolver.setApplicationContext((ApplicationContext)new MockApplicationContext());
        resolver.initialize();
        Iterable results = resolver.resolve(requestContext);
        Assert.assertNotNull((Object)results);
        Iterator resultItr = results.iterator();
        Assert.assertTrue((boolean)resultItr.hasNext());
        Assert.assertSame(resultItr.next(), (Object)defaultRP);
        Assert.assertFalse((boolean)resultItr.hasNext());
        Assert.assertSame((Object)resolver.resolveSingle(requestContext), (Object)defaultRP);
    }

    @Test
    public void testAnon() throws Exception {
        ProfileRequestContext requestContext = new ProfileRequestContext();
        ((RelyingPartyContext)requestContext.getSubcontext(RelyingPartyContext.class, true)).setVerified(Boolean.valueOf(false));
        RelyingPartyConfiguration anonRP = new RelyingPartyConfiguration();
        anonRP.setId("anonRPId");
        anonRP.setResponderId("anonRPResp");
        anonRP.setDetailedErrors(true);
        anonRP.setActivationCondition((Predicate)Predicates.alwaysTrue());
        anonRP.initialize();
        RelyingPartyConfiguration defaultRP = new RelyingPartyConfiguration();
        defaultRP.setId("defaultRPId");
        defaultRP.setResponderId("defaultRPResp");
        defaultRP.setDetailedErrors(true);
        defaultRP.initialize();
        DefaultRelyingPartyConfigurationResolver resolver = new DefaultRelyingPartyConfigurationResolver();
        resolver.setId("test");
        resolver.setUnverifiedConfiguration(anonRP);
        resolver.setDefaultConfiguration(defaultRP);
        resolver.setApplicationContext((ApplicationContext)new MockApplicationContext());
        resolver.initialize();
        Iterable results = resolver.resolve(requestContext);
        Assert.assertNotNull((Object)results);
        Iterator resultItr = results.iterator();
        Assert.assertTrue((boolean)resultItr.hasNext());
        Assert.assertSame(resultItr.next(), (Object)anonRP);
        Assert.assertFalse((boolean)resultItr.hasNext());
        Assert.assertSame((Object)resolver.resolveSingle(requestContext), (Object)anonRP);
    }

    @Test
    public void testResolve() throws Exception {
        ProfileRequestContext requestContext = new ProfileRequestContext();
        ((RelyingPartyContext)requestContext.getSubcontext(RelyingPartyContext.class, true)).setVerified(Boolean.valueOf(true));
        RelyingPartyConfiguration anonRP = new RelyingPartyConfiguration();
        anonRP.setId("anonRPId");
        anonRP.setResponderId("anonRPResp");
        anonRP.setDetailedErrors(true);
        anonRP.initialize();
        RelyingPartyConfiguration defaultRP = new RelyingPartyConfiguration();
        defaultRP.setId("defaultRPId");
        defaultRP.setResponderId("defaultRPResp");
        defaultRP.setDetailedErrors(true);
        defaultRP.initialize();
        RelyingPartyConfiguration one = new RelyingPartyConfiguration();
        one.setId("one");
        one.setResponderId("foo");
        one.setDetailedErrors(true);
        one.initialize();
        RelyingPartyConfiguration two = new RelyingPartyConfiguration();
        two.setId("two");
        two.setResponderId("foo");
        two.setDetailedErrors(true);
        two.setActivationCondition((Predicate)Predicates.alwaysFalse());
        two.initialize();
        RelyingPartyConfiguration three = new RelyingPartyConfiguration();
        three.setId("three");
        three.setResponderId("foo");
        three.setDetailedErrors(true);
        three.initialize();
        List<RelyingPartyConfiguration> rpConfigs = Arrays.asList(one, two, three);
        DefaultRelyingPartyConfigurationResolver resolver = new DefaultRelyingPartyConfigurationResolver();
        resolver.setId("test");
        resolver.setRelyingPartyConfigurations(rpConfigs);
        resolver.setUnverifiedConfiguration(anonRP);
        resolver.setDefaultConfiguration(defaultRP);
        resolver.setApplicationContext((ApplicationContext)new MockApplicationContext());
        resolver.initialize();
        Iterable results = resolver.resolve(requestContext);
        Assert.assertNotNull((Object)results);
        Iterator resultItr = results.iterator();
        Assert.assertTrue((boolean)resultItr.hasNext());
        Assert.assertSame(resultItr.next(), (Object)one);
        Assert.assertTrue((boolean)resultItr.hasNext());
        Assert.assertSame(resultItr.next(), (Object)three);
        Assert.assertFalse((boolean)resultItr.hasNext());
        RelyingPartyConfiguration result = resolver.resolveSingle(requestContext);
        Assert.assertSame((Object)result, (Object)one);
        results = resolver.resolve(null);
        Assert.assertNotNull((Object)results);
        resultItr = results.iterator();
        Assert.assertFalse((boolean)resultItr.hasNext());
        result = resolver.resolveSingle(null);
        Assert.assertNull((Object)result);
    }
}

