/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.ScratchContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@ThreadSafe
public final class InitializeProfileRequestContext
extends AbstractProfileAction {
    @Nullable
    private String profileId;
    @Nullable
    private String legacyProfileId;
    @Nullable
    private String loggingId;
    private boolean browserProfile;
    private boolean captureQueryParameters;

    public void setProfileId(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileId = StringSupport.trimOrNull((String)id);
    }

    public void setLegacyProfileId(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.legacyProfileId = StringSupport.trimOrNull((String)id);
    }

    public void setLoggingId(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loggingId = StringSupport.trimOrNull((String)id);
    }

    public void setBrowserProfile(boolean browser) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.browserProfile = browser;
    }

    public void setCaptureQueryParameters(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.captureQueryParameters = flag;
    }

    @Nonnull
    public Event execute(@Nonnull RequestContext springRequestContext) {
        HttpServletRequest request;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ProfileRequestContext prc = new ProfileRequestContext();
        if (this.profileId != null) {
            prc.setProfileId(this.profileId);
        }
        if (this.legacyProfileId != null) {
            prc.setLegacyProfileId(this.legacyProfileId);
        }
        if (this.loggingId != null) {
            prc.setLoggingId(this.loggingId);
        }
        prc.setBrowserProfile(this.browserProfile);
        springRequestContext.getConversationScope().put("opensamlProfileRequestContext", (Object)prc);
        if (this.captureQueryParameters && (request = this.getHttpServletRequest()) != null) {
            ((ScratchContext)prc.getSubcontext(ScratchContext.class, true)).getMap().putAll(request.getParameterMap());
        }
        return ActionSupport.buildProceedEvent((Object)((Object)this));
    }
}

