/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class LogContextTree
extends AbstractProfileAction {
    public static final String ATTRIB_DESC = "contextTreeDescription";
    private Logger log = LoggerFactory.getLogger((String)"CONTEXT_TREE");
    private String description;

    public void setDescription(@Nullable String value) {
        this.description = StringSupport.trimOrNull((String)value);
    }

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        String contextualDescription = null;
        SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springRequestContext != null && springRequestContext.getRequestContext() != null) {
            RequestContext requestContext = springRequestContext.getRequestContext();
            contextualDescription = requestContext.getAttributes().getString(ATTRIB_DESC);
        }
        if (contextualDescription == null) {
            contextualDescription = this.description;
        }
        if (contextualDescription != null) {
            this.log.debug("Context tree contextual description: {}", (Object)contextualDescription);
        }
        this.logContext((BaseContext)profileRequestContext, 0);
    }

    private void logContext(BaseContext current, int indent) {
        if (current == null) {
            return;
        }
        String indentString = this.getIndent(indent);
        if (current instanceof ProfileRequestContext) {
            ProfileRequestContext prc = (ProfileRequestContext)current;
            this.log.debug("{} PRC: {}", (Object)indentString, (Object)prc.getClass().getName());
            for (Object subcontext : prc) {
                this.logContext((BaseContext)subcontext, indent + 1);
            }
            MessageContext inbound = prc.getInboundMessageContext();
            if (inbound != null) {
                this.log.debug("{} PRC InboundMessageContext: {}", (Object)indentString, (Object)inbound.getClass().getName());
                for (BaseContext subcontext : inbound) {
                    this.logContext(subcontext, indent + 1);
                }
            } else {
                this.log.debug("{} PRC InboundMessageContext not present", (Object)indentString);
            }
            MessageContext outbound = prc.getOutboundMessageContext();
            if (outbound != null) {
                this.log.debug("{} PRC OutboundMessageContext: {}", (Object)indentString, (Object)outbound.getClass().getName());
                for (BaseContext subcontext : outbound) {
                    this.logContext(subcontext, indent + 1);
                }
            } else {
                this.log.debug("{} PRC OutboundMessageContext not present", (Object)indentString);
            }
        } else {
            this.log.debug("{} {}", (Object)indentString, (Object)current.getClass().getName());
            for (BaseContext subcontext : current) {
                this.logContext(subcontext, indent + 1);
            }
        }
    }

    private String getIndent(int indent) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            buffer.append("----");
        }
        return buffer.toString();
    }
}

