/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.profile.impl.MetadataQueryRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.opensaml.saml.common.messaging.context.SAMLMetadataLookupParametersContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.metadata.resolver.DetectDuplicateEntityIDs;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataQueryRequestDecoder
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    @NotEmpty
    public static final String ENTITY_ID_PARAM = "entityID";
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_PARAM = "protocol";
    @Nonnull
    @NotEmpty
    public static final String SAML1_PARAM = "saml1";
    @Nonnull
    @NotEmpty
    public static final String SAML2_PARAM = "saml2";
    @Nonnull
    @NotEmpty
    public static final String CAS_PARAM = "cas";
    @Nonnull
    @NotEmpty
    public static final String DETECT_DUPLICATES_PARAM = "detectDuplicateEntityIDs";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MetadataQueryRequestDecoder.class);

    protected void doDecode() throws MessageDecodingException {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            throw new MessageDecodingException("Unable to locate HttpServletRequest");
        }
        MetadataQueryRequest message = new MetadataQueryRequest();
        message.setEntityID(this.getEntityID(request));
        message.setProtocol(this.getProtocol(request));
        message.setDetectDuplicateEntityIDs(this.getDetectDuplicateEntityIDs(request));
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)message);
        this.setMessageContext(messageContext);
        SAMLPeerEntityContext peerCtx = new SAMLPeerEntityContext();
        peerCtx.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        peerCtx.setEntityId(message.getEntityID());
        messageContext.addSubcontext((BaseContext)peerCtx, true);
        if (message.getProtocol() != null) {
            ((SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class, true)).setProtocol(message.getProtocol());
        }
        if (message.getDetectDuplicateEntityIDs() != null) {
            ((SAMLMetadataLookupParametersContext)messageContext.getSubcontext(SAMLMetadataLookupParametersContext.class, true)).setDetectDuplicateEntityIDs(message.getDetectDuplicateEntityIDs());
        }
    }

    @Nonnull
    @NotEmpty
    protected String getEntityID(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String name = StringSupport.trimOrNull((String)request.getParameter(ENTITY_ID_PARAM));
        if (name == null) {
            throw new MessageDecodingException("Request did not contain the entityID query parameter.");
        }
        return name;
    }

    @Nullable
    protected String getProtocol(@Nonnull HttpServletRequest request) {
        String protocol = StringSupport.trimOrNull((String)request.getParameter(PROTOCOL_PARAM));
        if (protocol != null) {
            return protocol;
        }
        if (request.getParameter(SAML1_PARAM) != null) {
            return "urn:oasis:names:tc:SAML:1.1:protocol";
        }
        if (request.getParameter(SAML2_PARAM) != null) {
            return "urn:oasis:names:tc:SAML:2.0:protocol";
        }
        if (request.getParameter(CAS_PARAM) != null) {
            return "https://www.apereo.org/cas/protocol";
        }
        return null;
    }

    @Nullable
    protected DetectDuplicateEntityIDs getDetectDuplicateEntityIDs(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String strategy = StringSupport.trimOrNull((String)request.getParameter(DETECT_DUPLICATES_PARAM));
        if (strategy != null) {
            try {
                return DetectDuplicateEntityIDs.valueOf((String)strategy);
            }
            catch (IllegalArgumentException e) {
                throw new MessageDecodingException("Saw invalid value for param: detectDuplicateEntityIDs", (Exception)e);
            }
        }
        return null;
    }
}

