/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.config.ConditionalProfileConfiguration;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectProfileConfiguration
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectProfileConfiguration.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nullable
    @NotEmpty
    private String profileId;
    @Nullable
    private RelyingPartyContext rpCtx;
    private boolean failIfMissing = true;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setProfileId(@Nullable @NotEmpty String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileId = StringSupport.trimOrNull((String)id);
    }

    public void setFailIfMissing(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.failIfMissing = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.rpCtx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (this.rpCtx.getConfiguration() == null) {
            this.log.debug("{} No relying party configuration associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyConfiguration rpConfig;
        ProfileConfiguration profileConfiguration;
        String targetId = this.profileId;
        if (targetId == null) {
            targetId = profileRequestContext.getProfileId();
        }
        if ((profileConfiguration = (rpConfig = this.rpCtx.getConfiguration()).getProfileConfiguration(profileRequestContext, targetId)) == null && this.profileId == null && profileRequestContext.getLegacyProfileId() != null && (profileConfiguration = rpConfig.getProfileConfiguration(profileRequestContext, profileRequestContext.getLegacyProfileId())) != null) {
            profileRequestContext.setProfileId(profileRequestContext.getLegacyProfileId());
        }
        if (profileConfiguration == null) {
            if (this.failIfMissing) {
                this.log.warn("{} Profile {} is not available for RP configuration {} (RPID {})", new Object[]{this.getLogPrefix(), targetId, rpConfig.getId(), this.rpCtx.getRelyingPartyId()});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            } else {
                this.log.debug("{} Profile {} is not available for RP configuration {} (RPID {})", new Object[]{this.getLogPrefix(), targetId, rpConfig.getId(), this.rpCtx.getRelyingPartyId()});
            }
        } else if (profileConfiguration instanceof ConditionalProfileConfiguration && !((ConditionalProfileConfiguration)profileConfiguration).getActivationCondition().test(profileRequestContext)) {
            if (this.failIfMissing) {
                this.log.warn("{} Profile {} is not active for RP configuration {} (RPID {})", new Object[]{this.getLogPrefix(), targetId, rpConfig.getId(), this.rpCtx.getRelyingPartyId()});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            } else {
                this.log.debug("{} Profile {} is not active for RP configuration {} (RPID {})", new Object[]{this.getLogPrefix(), targetId, rpConfig.getId(), this.rpCtx.getRelyingPartyId()});
            }
        } else {
            this.rpCtx.setProfileConfig(profileConfiguration);
        }
    }
}

