/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.CriteriaRelyingPartyConfigurationResolver;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Resolver;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.criterion.ProfileRequestContextCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelectRelyingPartyConfiguration
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectRelyingPartyConfiguration.class);
    @NonnullAfterInit
    private Resolver<RelyingPartyConfiguration, ?> rpConfigResolver;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nullable
    private RelyingPartyContext relyingPartyCtx;

    public void setRelyingPartyConfigurationResolver(@Nonnull Resolver<RelyingPartyConfiguration, ?> resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.rpConfigResolver = (Resolver)Constraint.isNotNull(resolver, (String)"Relying party configuration resolver cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.rpConfigResolver == null) {
            throw new ComponentInitializationException("RelyingPartyConfigurationResolver cannot be null");
        }
    }

    public boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.relyingPartyCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.relyingPartyCtx == null) {
            this.log.debug("{} No relying party context available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        return true;
    }

    public void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            RelyingPartyConfiguration config;
            if (this.rpConfigResolver instanceof RelyingPartyConfigurationResolver) {
                config = (RelyingPartyConfiguration)((RelyingPartyConfigurationResolver)this.rpConfigResolver).resolveSingle((Object)profileRequestContext);
            } else if (this.rpConfigResolver instanceof CriteriaRelyingPartyConfigurationResolver) {
                CriteriaSet criteria = new CriteriaSet();
                if (this.relyingPartyCtx.getParent() == profileRequestContext) {
                    criteria.add((Object)new ProfileRequestContextCriterion(profileRequestContext));
                    config = (RelyingPartyConfiguration)((CriteriaRelyingPartyConfigurationResolver)this.rpConfigResolver).resolveSingle((Object)criteria);
                } else {
                    ProfileRequestContext newPRC = new ProfileRequestContext();
                    BaseContext originalParent = this.relyingPartyCtx.getParent();
                    newPRC.addSubcontext((BaseContext)this.relyingPartyCtx);
                    criteria.add((Object)new ProfileRequestContextCriterion(newPRC));
                    config = (RelyingPartyConfiguration)((CriteriaRelyingPartyConfigurationResolver)this.rpConfigResolver).resolveSingle((Object)criteria);
                    if (originalParent != null) {
                        originalParent.addSubcontext((BaseContext)this.relyingPartyCtx);
                    }
                }
            } else {
                this.log.error("{} Unsupported resolver type: {}", (Object)this.getLogPrefix(), (Object)this.rpConfigResolver.getClass().getName());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
                return;
            }
            if (config == null) {
                this.log.debug("{} No relying party configuration applies to this request", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
                return;
            }
            this.log.debug("{} Found relying party configuration {} for request", (Object)this.getLogPrefix(), (Object)config.getId());
            this.relyingPartyCtx.setConfiguration(config);
        }
        catch (ResolverException e) {
            this.log.error("{} Error trying to resolve relying party configuration", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
        }
    }
}

