/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.AbstractProfileInterceptorAction;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFlowsByNonBrowserSupport
extends AbstractProfileInterceptorAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterFlowsByNonBrowserSupport.class);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        if (profileRequestContext.isBrowserProfile()) {
            this.log.debug("{} Request does not have non-browser requirement, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return super.doPreExecute(profileRequestContext, interceptorContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        Map availableFlows = interceptorContext.getAvailableFlows();
        Iterator descriptorIterator = availableFlows.entrySet().iterator();
        while (descriptorIterator.hasNext()) {
            ProfileInterceptorFlowDescriptor descriptor = (ProfileInterceptorFlowDescriptor)descriptorIterator.next().getValue();
            if (descriptor.isNonBrowserSupported()) {
                this.log.debug("{} Retaining flow '{}', it supports non-browser authentication", (Object)this.getLogPrefix(), (Object)descriptor.getId());
                continue;
            }
            this.log.debug("{} Removing flow '{}', it does not support non-browser authentication", (Object)this.getLogPrefix(), (Object)descriptor.getId());
            descriptorIterator.remove();
        }
        if (availableFlows.size() == 0) {
            this.log.info("{} No available interceptor flows remain after filtering", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Available interceptor flows after filtering: '{}'", (Object)this.getLogPrefix(), (Object)availableFlows);
        }
    }
}

