/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.messaging.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.CriteriaRelyingPartyConfigurationResolver;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelectRelyingPartyConfiguration
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectRelyingPartyConfiguration.class);
    @NonnullAfterInit
    private CriteriaRelyingPartyConfigurationResolver rpConfigResolver;
    @Nonnull
    private Function<MessageContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class).compose((Function)new RecursiveTypedParentContextLookup(InOutOperationContext.class));
    @Nullable
    private RelyingPartyContext relyingPartyCtx;

    public void setRelyingPartyConfigurationResolver(@Nonnull CriteriaRelyingPartyConfigurationResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.rpConfigResolver = (CriteriaRelyingPartyConfigurationResolver)Constraint.isNotNull((Object)resolver, (String)"Relying party configuration resolver cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<MessageContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.rpConfigResolver == null) {
            throw new ComponentInitializationException("RelyingPartyConfigurationResolver cannot be null");
        }
    }

    public boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.relyingPartyCtx = this.relyingPartyContextLookupStrategy.apply(messageContext);
        if (this.relyingPartyCtx == null) {
            this.log.debug("{} No relying party context available", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No relying party context available");
        }
        if (this.relyingPartyCtx.getRelyingPartyId() == null) {
            this.log.debug("{} No relying party ID available", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No relying party ID available");
        }
        return super.doPreInvoke(messageContext);
    }

    public void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        try {
            CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.relyingPartyCtx.getRelyingPartyId())});
            RelyingPartyConfiguration config = (RelyingPartyConfiguration)this.rpConfigResolver.resolveSingle((Object)criteria);
            if (config == null) {
                this.log.debug("{} No relying party configuration applies to this request", (Object)this.getLogPrefix());
                throw new MessageHandlerException("No relying party configuration resolved for this request");
            }
            this.log.debug("{} Found relying party configuration {} for request", (Object)this.getLogPrefix(), (Object)config.getId());
            this.relyingPartyCtx.setConfiguration(config);
        }
        catch (ResolverException e) {
            this.log.error("{} Error trying to resolve relying party configuration: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            throw new MessageHandlerException("Error trying to resolve relying party configuration", (Exception)((Object)e));
        }
    }
}

