/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty.impl;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.CriteriaRelyingPartyConfigurationResolver;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.Resolver;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.criterion.ProfileRequestContextCriterion;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriteriaSelfEntityIDResolver
extends AbstractIdentifiedInitializableComponent
implements Resolver<String, CriteriaSet>,
IdentifiableComponent {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(CriteriaSelfEntityIDResolver.class);
    @NonnullAfterInit
    private CriteriaRelyingPartyConfigurationResolver rpcResolver;

    public void setRelyingPartyConfigurationResolver(@Nullable CriteriaRelyingPartyConfigurationResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.rpcResolver = resolver;
    }

    public void setId(@Nonnull @NotEmpty String componentId) {
        super.setId(componentId);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.rpcResolver == null) {
            throw new ComponentInitializationException("CriteriaRelyingPartyConfigurationResolver was null");
        }
    }

    protected void doDestroy() {
        this.rpcResolver = null;
        super.doDestroy();
    }

    @Nonnull
    @NonnullElements
    public Iterable<String> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        String entityID = this.resolveSingle(criteria);
        if (entityID != null) {
            return Collections.singletonList(entityID);
        }
        return Collections.emptyList();
    }

    @Nullable
    public String resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ProfileRequestContext prc = this.buildContext(criteria);
        CriteriaSet prcSet = new CriteriaSet(new Criterion[]{new ProfileRequestContextCriterion(prc)});
        RelyingPartyConfiguration rpc = (RelyingPartyConfiguration)this.rpcResolver.resolveSingle((Object)prcSet);
        if (rpc != null) {
            return rpc.getResponderId(prc);
        }
        return null;
    }

    @Nullable
    private ProfileRequestContext buildContext(@Nullable CriteriaSet criteria) {
        if (criteria == null) {
            return null;
        }
        if (criteria.contains(ProfileRequestContextCriterion.class)) {
            return ((ProfileRequestContextCriterion)criteria.get(ProfileRequestContextCriterion.class)).getProfileRequestContext();
        }
        String entityID = this.resolveEntityID(criteria);
        this.log.debug("Resolved effective entityID from criteria: {}", (Object)entityID);
        EntityDescriptor entityDescriptor = this.resolveEntityDescriptor(criteria);
        this.log.debug("Resolved effective entity descriptor from criteria: {}", (Object)entityDescriptor);
        RoleDescriptor roleDescriptor = this.resolveRoleDescriptor(criteria);
        this.log.debug("Resolved effective role descriptor from criteria: {}", (Object)roleDescriptor);
        if (entityID != null || entityDescriptor != null || roleDescriptor != null) {
            ProfileRequestContext prc = new ProfileRequestContext();
            RelyingPartyContext rpc = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class, true);
            rpc.setVerified(Boolean.valueOf(true));
            rpc.setRelyingPartyId(entityID);
            if (entityDescriptor != null || roleDescriptor != null) {
                SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)prc.getSubcontext(SAMLPeerEntityContext.class, true);
                rpc.setRelyingPartyIdContextTree((BaseContext)peerContext);
                peerContext.setEntityId(entityID);
                if (roleDescriptor != null) {
                    peerContext.setRole(roleDescriptor.getSchemaType() != null ? roleDescriptor.getSchemaType() : roleDescriptor.getElementQName());
                }
                SAMLMetadataContext metadataContext = (SAMLMetadataContext)peerContext.getSubcontext(SAMLMetadataContext.class, true);
                metadataContext.setEntityDescriptor(entityDescriptor);
                metadataContext.setRoleDescriptor(roleDescriptor);
            }
            return prc;
        }
        return null;
    }

    private String resolveEntityID(@Nonnull CriteriaSet criteria) {
        if (criteria.contains(EntityIdCriterion.class)) {
            return ((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId();
        }
        EntityDescriptor ed = this.resolveEntityDescriptor(criteria);
        if (ed != null) {
            return ed.getEntityID();
        }
        return null;
    }

    private EntityDescriptor resolveEntityDescriptor(@Nonnull CriteriaSet criteria) {
        RoleDescriptor rd = this.resolveRoleDescriptor(criteria);
        if (rd != null && rd.getParent() != null && rd.getParent() instanceof EntityDescriptor) {
            return (EntityDescriptor)rd.getParent();
        }
        return null;
    }

    private RoleDescriptor resolveRoleDescriptor(@Nonnull CriteriaSet criteria) {
        if (criteria.contains(RoleDescriptorCriterion.class)) {
            return ((RoleDescriptorCriterion)criteria.get(RoleDescriptorCriterion.class)).getRole();
        }
        return null;
    }
}

