/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.audit.impl;

import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.audit.impl.WriteAuditLog;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.profile.context.AuditContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class WriteAuditLogTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private FilteringAction action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        MockHttpServletRequest mock = new MockHttpServletRequest();
        mock.setRemoteAddr("192.168.1.1");
        mock.addHeader("User-Agent", (Object)"Mock");
        mock.setServerName("idp.example.org");
        mock.setServerPort(443);
        mock.setScheme("https");
        mock.setRequestURI("/path/to/foo");
        this.action = new FilteringAction();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)mock));
    }

    @Test
    public void testNoRules() throws Exception {
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testFormat() {
        this.action.setFormattingMap(CollectionSupport.singletonMap((Object)"category", (Object)"Foo"));
        List format = (List)this.action.getFormattingMap().get("category");
        Assert.assertEquals((int)format.size(), (int)1);
        Assert.assertEquals((String)((String)format.get(0)), (String)"Foo");
        this.action.setFormattingMap(CollectionSupport.singletonMap((Object)"category", (Object)"%Foo"));
        format = (List)this.action.getFormattingMap().get("category");
        Assert.assertEquals((int)format.size(), (int)1);
        Assert.assertEquals((String)((String)format.get(0)), (String)"%Foo");
        this.action.setFormattingMap(CollectionSupport.singletonMap((Object)"category", (Object)"%Foo|%Bar %Baz%Bat"));
        format = (List)this.action.getFormattingMap().get("category");
        Assert.assertEquals((int)format.size(), (int)5);
        Assert.assertEquals((Object[])format.toArray(), (Object[])new String[]{"%Foo", "|", "%Bar", " ", "%Baz%Bat"});
        this.action.setFormattingMap(CollectionSupport.singletonMap((Object)"category", (Object)"%Foo|%Bar %Baz-Bat"));
        format = (List)this.action.getFormattingMap().get("category");
        Assert.assertEquals((int)format.size(), (int)5);
        Assert.assertEquals((Object[])format.toArray(), (Object[])new String[]{"%Foo", "|", "%Bar", " ", "%Baz-Bat"});
        this.action.setFormattingMap(CollectionSupport.singletonMap((Object)"category", (Object)"%Foo|%Bar %%%"));
        format = (List)this.action.getFormattingMap().get("category");
        Assert.assertEquals((int)format.size(), (int)5);
        Assert.assertEquals((Object[])format.toArray(), (Object[])new String[]{"%Foo", "|", "%Bar", " ", "%%%"});
        this.action.setFormattingMap(CollectionSupport.singletonMap((Object)"category", (Object)"%Foo|%Bar % %%"));
        format = (List)this.action.getFormattingMap().get("category");
        Assert.assertEquals((int)format.size(), (int)7);
        Assert.assertEquals((Object[])format.toArray(), (Object[])new String[]{"%Foo", "|", "%Bar", " ", "%", " ", "%%"});
    }

    @Test
    public void testTwo() throws ComponentInitializationException {
        AuditContext ac = (AuditContext)this.prc.ensureSubcontext(AuditContext.class);
        ac.getFieldValues("A").add("foo");
        ac.getFieldValues("B").add("bar");
        ac.getFieldValues("B").add("baz");
        this.action.setFormattingMap(CollectionSupport.singletonMap((Object)"category", (Object)"%A %B"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.action.getResult(), (String)"foo bar,baz");
    }

    @Test
    public void testMissing() throws ComponentInitializationException {
        AuditContext ac = (AuditContext)this.prc.ensureSubcontext(AuditContext.class);
        ac.getFieldValues("A").add("foo");
        ac.getFieldValues("B").add("bar");
        ac.getFieldValues("B").add("baz");
        this.action.setFormattingMap(CollectionSupport.singletonMap((Object)"category", (Object)"%A - %C|%B"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.action.getResult(), (String)"foo - |bar,baz");
    }

    @Test
    public void testServletRequest() throws ComponentInitializationException {
        this.action.setFormattingMap(CollectionSupport.singletonMap((Object)"category", (Object)"%a %URL - %UA"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.action.getResult(), (String)"192.168.1.1 https://idp.example.org/path/to/foo - Mock");
    }

    class FilteringAction
    extends WriteAuditLog {
        private String result;

        FilteringAction() {
        }

        public String getResult() {
            return this.result;
        }

        protected void filter(@Nonnull StringBuilder entry) {
            this.result = entry.toString();
        }
    }
}

