/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.shibboleth.idp.profile.testing.MockProfileConfiguration;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.security.config.BasicSecurityConfiguration;
import org.opensaml.security.config.SecurityConfiguration;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractProfileConfigurationTest {
    private Object nullObj;

    @Test
    public void testProfileId() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        Assert.assertEquals((String)config.getId(), (String)"mock");
        try {
            config = new MockProfileConfiguration((String)this.nullObj);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            config = new MockProfileConfiguration("");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testSecurityConfiguration() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        Assert.assertNotNull((Object)config.getSecurityConfiguration(null));
        BasicSecurityConfiguration securityConfig = new BasicSecurityConfiguration();
        config.setSecurityConfiguration((SecurityConfiguration)securityConfig);
        Assert.assertSame((Object)config.getSecurityConfiguration(null), (Object)securityConfig);
    }

    @Test
    public void testIndirectSecurityConfiguration() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        config.setSecurityConfiguration(null);
        BasicSecurityConfiguration securityConfig = new BasicSecurityConfiguration();
        config.setSecurityConfigurationLookupStrategy(FunctionSupport.constant((Object)securityConfig));
        Assert.assertSame((Object)config.getSecurityConfiguration(null), (Object)securityConfig);
    }

    @Test
    public void testInboundFlows() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        List<String> flows = Arrays.asList("foo", "bar");
        config.setInboundInterceptorFlows(flows);
        Assert.assertEquals((Collection)config.getInboundInterceptorFlows(null), flows);
    }

    @Test
    public void testIndirectInboundFlows() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        List<String> flows = Arrays.asList("foo", "bar");
        config.setInboundInterceptorFlowsLookupStrategy(FunctionSupport.constant(flows));
        Assert.assertEquals((Collection)config.getInboundInterceptorFlows(null), flows);
    }

    @Test
    public void testOutboundFlows() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        List<String> flows = Arrays.asList("foo", "bar");
        config.setOutboundInterceptorFlows(flows);
        Assert.assertEquals((Collection)config.getOutboundInterceptorFlows(null), flows);
    }

    @Test
    public void testIndirectOutboundFlows() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        List<String> flows = Arrays.asList("foo", "bar");
        config.setOutboundInterceptorFlowsLookupStrategy(FunctionSupport.constant(flows));
        Assert.assertEquals((Collection)config.getOutboundInterceptorFlows(null), flows);
    }

    @Test
    public void testDisallowedFeatures() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        Assert.assertEquals((int)config.getDisallowedFeatures(null), (int)0);
        config.setDisallowedFeatures(5);
        Assert.assertTrue((boolean)config.isFeatureDisallowed(null, 1));
        Assert.assertFalse((boolean)config.isFeatureDisallowed(null, 2));
        Assert.assertTrue((boolean)config.isFeatureDisallowed(null, 4));
    }

    @Test
    public void testIndirectDisallowedFeatures() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        Assert.assertEquals((int)config.getDisallowedFeatures(null), (int)0);
        config.setDisallowedFeaturesLookupStrategy(FunctionSupport.constant((Object)5));
        Assert.assertTrue((boolean)config.isFeatureDisallowed(null, 1));
        Assert.assertFalse((boolean)config.isFeatureDisallowed(null, 2));
        Assert.assertTrue((boolean)config.isFeatureDisallowed(null, 4));
    }
}

