/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate.tests;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.idp.profile.context.navigate.SpringStatusMessageLookupFunction;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SpringStatusMessageLookupFunctionTest {
    private MockRequestContext springRequestContext;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.springRequestContext = (MockRequestContext)new RequestContextBuilder().buildRequestContext();
        this.prc = (ProfileRequestContext)this.springRequestContext.getConversationScope().get("opensamlProfileRequestContext");
        ((SpringRequestContext)this.prc.ensureSubcontext(SpringRequestContext.class)).setRequestContext((RequestContext)this.springRequestContext);
    }

    @Test
    public void testMappedMessage() {
        SpringStatusMessageLookupFunction fn = new SpringStatusMessageLookupFunction();
        fn.setMessageSource((MessageSource)new MockMessageSource());
        String message = fn.apply(this.prc);
        Assert.assertNull((Object)message);
        this.springRequestContext.setCurrentEvent(new Event((Object)this, "Mappable"));
        message = fn.apply(this.prc);
        Assert.assertEquals((String)message, (String)"Mapped");
    }

    private class MockMessageSource
    implements MessageSource {
        private MockMessageSource() {
        }

        public String getMessage(@Nonnull String code, @Nullable Object[] args, @Nullable String defaultMessage, @Nonnull Locale locale) {
            if (code.equals("Mappable")) {
                return "Mapped";
            }
            return defaultMessage;
        }

        @Nonnull
        public String getMessage(@Nonnull String code, @Nullable Object[] args, @Nonnull Locale locale) throws NoSuchMessageException {
            if (code.equals("Mappable")) {
                return "Mapped";
            }
            throw new NoSuchMessageException("No such message");
        }

        @Nonnull
        public String getMessage(@Nonnull MessageSourceResolvable resolvable, @Nonnull Locale locale) throws NoSuchMessageException {
            String[] codes = resolvable.getCodes();
            assert (codes != null && codes.length >= 1);
            if (codes[0].equals("Mappable")) {
                return "Mapped";
            }
            throw new NoSuchMessageException("No such message");
        }
    }
}

