/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.component.UninitializedComponentException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.PreviousEventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractProfileActionTest {
    @Test
    public void testActionExecution() throws Exception {
        RequestContext springRequestContext = new RequestContextBuilder().buildRequestContext();
        MockProfileAction action = new MockProfileAction();
        action.initialize();
        Event result = action.execute(springRequestContext);
        Assert.assertTrue((boolean)action.isExecuted());
        ActionTestingSupport.assertProceedEvent((Event)result);
        action = new MockProfileAction(new RuntimeException());
        action.initialize();
        try {
            action.execute(springRequestContext);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        action = new MockProfileAction(new RuntimeException());
        try {
            action.execute(springRequestContext);
            Assert.fail();
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
    }

    @Test
    public void testActionEvent() throws Exception {
        RequestContext springRequestContext = new RequestContextBuilder().buildRequestContext();
        MockProfileAction action = new MockProfileAction("Event1", "Event2");
        action.initialize();
        Event result = action.execute(springRequestContext);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidPreviousEvent");
        action = new MockProfileAction("Event1", "InvalidPreviousEvent");
        action.initialize();
        result = action.execute(springRequestContext);
        ActionTestingSupport.assertEvent((Event)result, (String)"Event1");
        action = new MockProfileAction("Event2", "Event1");
        action.initialize();
        result = action.execute(springRequestContext);
        ActionTestingSupport.assertEvent((Event)result, (String)"Event2");
        action = new MockProfileAction("Event3", "Event1");
        action.initialize();
        result = action.execute(springRequestContext);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidPreviousEvent");
    }

    private class MockProfileAction
    extends AbstractProfileAction {
        private final String newEvent;
        private final String prevEvent;
        private final RuntimeException thrownException;
        private boolean executed;

        public MockProfileAction() {
            this.thrownException = null;
            this.newEvent = null;
            this.prevEvent = null;
        }

        public MockProfileAction(RuntimeException exception) {
            this.thrownException = exception;
            this.newEvent = null;
            this.prevEvent = null;
        }

        public MockProfileAction(String newEv, String prev) {
            this.newEvent = newEv;
            this.prevEvent = prev;
            this.thrownException = null;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
            this.executed = true;
            PreviousEventContext prevCtx = (PreviousEventContext)profileRequestContext.getSubcontext(PreviousEventContext.class);
            if (this.prevEvent != null) {
                if (prevCtx == null || !this.prevEvent.equals(prevCtx.getEvent())) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidPreviousEvent");
                    return;
                }
            } else if (prevCtx != null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidPreviousEvent");
                return;
            }
            if (this.thrownException != null) {
                throw this.thrownException;
            }
            if (this.newEvent != null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.newEvent);
            }
        }
    }
}

