/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import net.shibboleth.idp.profile.impl.RecordResponseComplete;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RecordResponseCompleteTest {
    RecordResponseComplete action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new RecordResponseComplete();
        this.action.initialize();
    }

    @Test
    public void testRecordResponseComplete() throws Exception {
        RequestContext requestContext = new RequestContextBuilder().buildRequestContext();
        Assert.assertFalse((boolean)requestContext.getExternalContext().isResponseComplete());
        Event result = this.action.execute(requestContext);
        Assert.assertTrue((boolean)requestContext.getExternalContext().isResponseComplete());
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void testResponseAlreadyCompleted() throws Exception {
        RequestContext requestContext = new RequestContextBuilder().buildRequestContext();
        requestContext.getExternalContext().recordResponseComplete();
        Assert.assertTrue((boolean)requestContext.getExternalContext().isResponseComplete());
        Event result = this.action.execute(requestContext);
        Assert.assertTrue((boolean)requestContext.getExternalContext().isResponseComplete());
        ActionTestingSupport.assertProceedEvent((Event)result);
    }
}

