/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import javax.script.ScriptException;
import net.shibboleth.idp.profile.ScriptedAction;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ScriptedActionTest {
    private RequestContext rc;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.rc = new RequestContextBuilder().buildRequestContext();
    }

    @Test
    public void testProceed() throws ScriptException, ComponentInitializationException {
        ScriptedAction action = ScriptedAction.inlineScript((String)"null");
        action.initialize();
        Event result = action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void testEvent() throws ScriptException, ComponentInitializationException {
        ScriptedAction action = ScriptedAction.inlineScript((String)"'foo'");
        action.initialize();
        Event result = action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"foo");
    }

    @Test
    public void testBadEvent() throws ScriptException, ComponentInitializationException {
        ScriptedAction action = ScriptedAction.inlineScript((String)"0");
        action.initialize();
        Event result = action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    @Test
    public void testBadScript() throws ScriptException, ComponentInitializationException {
        ScriptedAction action = ScriptedAction.inlineScript((String)"foo");
        action.initialize();
        try {
            action.execute(this.rc);
            Assert.fail((String)"Should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ScriptException));
        }
    }

    @Test
    public void testBadScriptHidden() throws ScriptException, ComponentInitializationException {
        ScriptedAction action = ScriptedAction.inlineScript((String)"foo");
        action.setHideExceptions(true);
        action.initialize();
        Event result = action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }
}

