/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.impl.SelectRelyingPartyConfiguration;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.BasicRelyingPartyConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SelectRelyingPartyConfigurationTest {
    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoResolver() throws ComponentInitializationException {
        SelectRelyingPartyConfiguration action = new SelectRelyingPartyConfiguration();
        action.initialize();
    }

    @Test
    public void testNoRelyingPartyContext() throws Exception {
        RequestContext src = new RequestContextBuilder().buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(src);
        assert (prc != null);
        prc.removeSubcontext(RelyingPartyContext.class);
        SelectRelyingPartyConfiguration action = new SelectRelyingPartyConfiguration();
        action.setRelyingPartyConfigurationResolver((ReloadableService)new MockResolver(null, null));
        action.initialize();
        Event event = action.execute(src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyContext");
    }

    @Test
    public void testNoRelyingPartyConfiguration() throws Exception {
        RequestContext src = new RequestContextBuilder().buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(src);
        assert (prc != null);
        RelyingPartyContext rpCtx = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class);
        assert (rpCtx != null);
        rpCtx.setConfiguration(null);
        SelectRelyingPartyConfiguration action = new SelectRelyingPartyConfiguration();
        action.setRelyingPartyConfigurationResolver((ReloadableService)new MockResolver(null, null));
        action.initialize();
        Event event = action.execute(src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyConfiguration");
    }

    @Test
    public void testUnableToResolveRelyingPartyConfiguration() throws Exception {
        RequestContext src = new RequestContextBuilder().buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(src);
        assert (prc != null);
        RelyingPartyContext rpCtx = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class);
        assert (rpCtx != null);
        rpCtx.setConfiguration(null);
        BasicRelyingPartyConfiguration config = new BasicRelyingPartyConfiguration();
        config.setId("foo");
        config.setIssuer("http://idp.example.org");
        config.setDetailedErrors(true);
        config.initialize();
        SelectRelyingPartyConfiguration action = new SelectRelyingPartyConfiguration();
        action.setRelyingPartyConfigurationResolver((ReloadableService)new MockResolver((RelyingPartyConfiguration)config, new ResolverException()));
        action.initialize();
        Event event = action.execute(src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyConfiguration");
    }

    @Test
    public void testResolveRelyingPartyConfiguration() throws Exception {
        RequestContext src = new RequestContextBuilder().buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(src);
        assert (prc != null);
        RelyingPartyContext rpCtx = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class);
        assert (rpCtx != null);
        rpCtx.setConfiguration(null);
        BasicRelyingPartyConfiguration config = new BasicRelyingPartyConfiguration();
        config.setId("foo");
        config.setIssuer("http://idp.example.org");
        config.setDetailedErrors(true);
        config.initialize();
        SelectRelyingPartyConfiguration action = new SelectRelyingPartyConfiguration();
        action.setRelyingPartyConfigurationResolver((ReloadableService)new MockResolver((RelyingPartyConfiguration)config, null));
        action.initialize();
        Event event = action.execute(src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RelyingPartyConfiguration resolvedConfig = rpCtx.getConfiguration();
        assert (resolvedConfig != null);
        Assert.assertEquals((String)resolvedConfig.getId(), (String)config.getId());
        Assert.assertEquals((String)resolvedConfig.getIssuer(prc), (String)config.getIssuer(prc));
        Assert.assertEquals((Map)resolvedConfig.getProfileConfigurations(prc), (Map)config.getProfileConfigurations(prc));
    }

    private class MockResolver
    extends AbstractIdentifiedInitializableComponent
    implements ReloadableService<RelyingPartyConfigurationResolver>,
    ServiceableComponent<RelyingPartyConfigurationResolver>,
    RelyingPartyConfigurationResolver {
        @Nullable
        RelyingPartyConfiguration configuration;
        private ResolverException exception;

        public MockResolver(@Nullable RelyingPartyConfiguration relyingPartyConfiguration, ResolverException resolverException) throws ComponentInitializationException {
            this.configuration = relyingPartyConfiguration;
            this.exception = resolverException;
            this.setId("mock");
            this.initialize();
        }

        @Nonnull
        public Iterable<RelyingPartyConfiguration> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
            if (this.exception != null) {
                throw this.exception;
            }
            assert (this.configuration != null);
            return CollectionSupport.singleton((Object)this.configuration);
        }

        public RelyingPartyConfiguration resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.configuration;
        }

        @Nonnull
        public Collection<Credential> getSigningCredentials() {
            return CollectionSupport.emptyList();
        }

        @Nonnull
        public Collection<Credential> getEncryptionCredentials() {
            return CollectionSupport.emptyList();
        }

        public Instant getLastSuccessfulReloadInstant() {
            return null;
        }

        public Instant getLastReloadAttemptInstant() {
            return null;
        }

        public Throwable getReloadFailureCause() {
            return null;
        }

        public void reload() {
        }

        @Nonnull
        public ServiceableComponent<RelyingPartyConfigurationResolver> getServiceableComponent() {
            return this;
        }

        @Nonnull
        public RelyingPartyConfigurationResolver getComponent() {
            return this;
        }

        public void close() {
        }
    }
}

