/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.component.UnmodifiableComponentException;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageService;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProfileInterceptorFlowDescriptorTest {
    private ProfileInterceptorFlowDescriptor descriptor;
    private RequestContext src;
    private ProfileRequestContext prc;
    private Object nullObj;

    @BeforeMethod
    public void setUp() throws Exception {
        this.descriptor = new ProfileInterceptorFlowDescriptor();
        this.descriptor.setId("test");
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
    }

    @Test
    public void testInstantation() throws Exception {
        Assert.assertEquals((String)this.descriptor.getId(), (String)"test");
        Assert.assertTrue((boolean)this.descriptor.isNonBrowserSupported());
        Assert.assertNull((Object)this.descriptor.getStorageService());
        Assert.assertTrue((boolean)this.descriptor.test(this.prc));
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableActivationCondition() throws Exception {
        this.descriptor.initialize();
        this.descriptor.setActivationCondition(PredicateSupport.alwaysFalse());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageService() throws Exception {
        this.descriptor.initialize();
        this.descriptor.setStorageService((StorageService)this.nullObj);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableNonBrowserSupport() throws Exception {
        this.descriptor.initialize();
        this.descriptor.setNonBrowserSupported(true);
    }

    @Test
    public void testEquality() {
        ProfileInterceptorFlowDescriptor descriptorWithSameId = new ProfileInterceptorFlowDescriptor();
        descriptorWithSameId.setId("test");
        Assert.assertTrue((boolean)this.descriptor.equals((Object)descriptorWithSameId));
        ProfileInterceptorFlowDescriptor descriptorWithDifferentId = new ProfileInterceptorFlowDescriptor();
        descriptorWithDifferentId.setId("differentId");
        Assert.assertFalse((boolean)this.descriptor.equals((Object)descriptorWithDifferentId));
    }

    @Test
    public void testMutatingPredicate() throws Exception {
        this.descriptor.setActivationCondition(PredicateSupport.alwaysFalse());
        this.descriptor.initialize();
        Assert.assertFalse((boolean)this.descriptor.test(this.prc));
    }

    @Test
    public void testMutatingNonBrowserSupport() {
        this.descriptor.setNonBrowserSupported(true);
        Assert.assertTrue((boolean)this.descriptor.isNonBrowserSupported());
        this.descriptor.setNonBrowserSupported(false);
        Assert.assertFalse((boolean)this.descriptor.isNonBrowserSupported());
    }
}

