/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.AbstractProfileInterceptorResult;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.interceptor.impl.WriteProfileInterceptorResultToStorage;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class WriteProfileInterceptorResultToStorageTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private MemoryStorageService ss;
    private WriteProfileInterceptorResultToStorage action;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.ss = new MemoryStorageService();
        this.ss.setId("test");
        this.ss.initialize();
        ProfileInterceptorFlowDescriptor descriptor = new ProfileInterceptorFlowDescriptor();
        descriptor.setStorageService((StorageService)this.ss);
        ProfileInterceptorContext pic = new ProfileInterceptorContext();
        pic.setAttemptedFlow(descriptor);
        this.prc.addSubcontext((BaseContext)pic);
        this.action = new WriteProfileInterceptorResultToStorage();
        this.action.initialize();
    }

    @Test
    public void testNoResults() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testNoAttemptedFlow() {
        this.prc.addSubcontext((BaseContext)new ProfileInterceptorContext(), true);
        ProfileInterceptorContext ctx = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (ctx != null && ctx.getAttemptedFlow() == null);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testNoStorageService() {
        ProfileInterceptorContext ctx = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (ctx != null);
        ctx.setAttemptedFlow(new ProfileInterceptorFlowDescriptor());
        ProfileInterceptorFlowDescriptor flow = ctx.getAttemptedFlow();
        assert (flow != null && flow.getStorageService() == null);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testCreateStorageRecord() throws Exception {
        MockProfileInterceptorResult result = new MockProfileInterceptorResult("context", "key", "value", null);
        ProfileInterceptorContext ctx = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (ctx != null);
        ctx.getResults().add(result);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        StorageRecord storageRecord = this.ss.read("context", "key");
        assert (storageRecord != null);
        Assert.assertEquals((String)storageRecord.getValue(), (String)"value");
        Assert.assertEquals((Long)storageRecord.getExpiration(), null);
    }

    @Test
    public void testCreateStorageRecordWithExpiration() throws Exception {
        Instant expiration = Instant.now().plusSeconds(60L);
        MockProfileInterceptorResult result = new MockProfileInterceptorResult("context", "key", "value", expiration);
        ProfileInterceptorContext ctx = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (ctx != null);
        ctx.getResults().add(result);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        StorageRecord storageRecord = this.ss.read("context", "key");
        assert (storageRecord != null);
        Assert.assertEquals((String)storageRecord.getValue(), (String)"value");
        Assert.assertEquals((Long)storageRecord.getExpiration(), (Long)expiration.toEpochMilli());
    }

    @Test
    public void testUpdateStorageRecord() throws Exception {
        Instant expiration = Instant.now().plusSeconds(60L);
        MockProfileInterceptorResult result = new MockProfileInterceptorResult("context", "key", "value", null);
        ProfileInterceptorContext ctx = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (ctx != null);
        ctx.getResults().add(result);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        StorageRecord storageRecord = this.ss.read("context", "key");
        assert (storageRecord != null);
        Assert.assertEquals((String)storageRecord.getValue(), (String)"value");
        Assert.assertEquals((Long)storageRecord.getExpiration(), null);
        result = new MockProfileInterceptorResult("context", "key", "value2", expiration);
        ctx.getResults().clear();
        ctx.getResults().add(result);
        event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        storageRecord = this.ss.read("context", "key");
        assert (storageRecord != null);
        Assert.assertEquals((String)storageRecord.getValue(), (String)"value2");
        Assert.assertEquals((Long)storageRecord.getExpiration(), (Long)expiration.toEpochMilli());
    }

    private class MockProfileInterceptorResult
    extends AbstractProfileInterceptorResult {
        public MockProfileInterceptorResult(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable String value, Instant expiration) {
            super(context, key, value, expiration);
        }
    }
}

