/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.support;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import net.shibboleth.idp.profile.support.PathInfoSupportingFlowUrlHandler;
import net.shibboleth.shared.collection.CollectionSupport;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PathInfoSupportingFlowUrlHandlerTest {
    MockHttpServletRequest request;
    PathInfoSupportingFlowUrlHandler handler;

    @BeforeMethod
    public void setUp() {
        this.request = new MockHttpServletRequest();
        this.handler = new PathInfoSupportingFlowUrlHandler();
    }

    @Test
    public void testNoPathInfo() {
        Assert.assertNull((Object)this.handler.getFlowId((HttpServletRequest)this.request));
    }

    @Test
    public void testNoneSupported() {
        this.request.setPathInfo("/admin/foo/bar/baz");
        Assert.assertEquals((String)"admin/foo/bar/baz", (String)this.handler.getFlowId((HttpServletRequest)this.request));
    }

    @Test
    public void testNoMatch() {
        this.request.setPathInfo("/admin/foo/bar/baz");
        this.handler.setSupportedFlows((Collection)CollectionSupport.singletonList((Object)"admit/fop"));
        Assert.assertEquals((String)"admin/foo/bar/baz", (String)this.handler.getFlowId((HttpServletRequest)this.request));
    }

    @Test
    public void testSuported() {
        this.request.setPathInfo("/admin/foo/bar/baz");
        this.handler.setSupportedFlows((Collection)CollectionSupport.singletonList((Object)"admin/foo/bar"));
        Assert.assertEquals((String)"admin/foo/bar", (String)this.handler.getFlowId((HttpServletRequest)this.request));
        this.handler.setSupportedFlows((Collection)CollectionSupport.singletonList((Object)"admin/foo"));
        Assert.assertEquals((String)"admin/foo", (String)this.handler.getFlowId((HttpServletRequest)this.request));
    }

    @Test
    public void testOverlapping() {
        this.request.setPathInfo("/admin/foo/bar/baz");
        this.handler.setSupportedFlows((Collection)CollectionSupport.arrayAsList((Object[])new String[]{"admin/foo/bar", "admin/foo", "admin"}));
        Assert.assertEquals((String)"admin/foo/bar", (String)this.handler.getFlowId((HttpServletRequest)this.request));
        this.handler.setSupportedFlows((Collection)CollectionSupport.arrayAsList((Object[])new String[]{"admin", "admin/foo", "admin/foo/bar"}));
        Assert.assertEquals((String)"admin", (String)this.handler.getFlowId((HttpServletRequest)this.request));
    }
}

