/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.support;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.support.StorageAwareCookieManager;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StorageAwareCookieManagerTest {
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private MemoryStorageService storage;
    private StorageAwareCookieManager cm;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.request = new MockHttpServletRequest();
        this.request.setAttribute("opensamlProfileRequestContext", (Object)new RequestContextBuilder().buildProfileRequestContext());
        this.response = new MockHttpServletResponse();
        this.storage = new MemoryStorageService();
        this.storage.setId("test");
        this.storage.setCleanupInterval(Duration.ZERO);
        this.storage.initialize();
        this.cm = new StorageAwareCookieManager();
        this.cm.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            @Nonnull
            public HttpServletRequest get() {
                return StorageAwareCookieManagerTest.this.request;
            }
        });
        this.cm.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            @Nonnull
            public HttpServletResponse get() {
                return StorageAwareCookieManagerTest.this.response;
            }
        });
        this.cm.setCookiePath("/idp");
        this.cm.setStorageService((StorageService)this.storage);
        this.cm.setUsernameLookupStrategy(FunctionSupport.constant((Object)"jdoe"));
        this.cm.setMaxAge(600);
        this.cm.initialize();
    }

    @Test
    public void testInitFailure() {
        StorageAwareCookieManager cm = new StorageAwareCookieManager();
        try {
            cm.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testCookieWithPath() throws ComponentInitializationException, IOException {
        this.cm.addCookie("foo", "bar");
        Cookie cookie = this.response.getCookie("foo");
        assert (cookie != null);
        Assert.assertEquals((String)cookie.getValue(), (String)"bar");
        Assert.assertEquals((String)cookie.getPath(), (String)"/idp");
        Assert.assertNull((Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((int)cookie.getMaxAge(), (int)600);
        StorageRecord record = this.storage.read(this.cm.getStorageContext(), "foo!jdoe");
        assert (record != null);
        Assert.assertEquals((long)record.getVersion(), (long)1L);
        Assert.assertEquals((String)record.getValue(), (String)"bar");
    }

    @Test
    public void testCookieNoPath() throws ComponentInitializationException, IOException {
        this.request.setContextPath("/idp");
        this.cm.addCookie("foo", "bar");
        Cookie cookie = this.response.getCookie("foo");
        assert (cookie != null);
        Assert.assertEquals((String)cookie.getValue(), (String)"bar");
        Assert.assertEquals((String)cookie.getPath(), (String)"/idp");
        Assert.assertNull((Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((int)cookie.getMaxAge(), (int)600);
        StorageRecord record = this.storage.read(this.cm.getStorageContext(), "foo!jdoe");
        assert (record != null);
        Assert.assertEquals((long)record.getVersion(), (long)1L);
        Assert.assertEquals((String)record.getValue(), (String)"bar");
    }

    @Test
    public void testCookieUnset() throws ComponentInitializationException, IOException {
        this.request.setContextPath("/idp");
        this.request.setCookies(new Cookie[]{new Cookie("foo", "bar")});
        this.cm.unsetCookie("foo");
        Cookie cookie = this.response.getCookie("foo");
        assert (cookie != null);
        Assert.assertNull((Object)cookie.getValue());
        Assert.assertEquals((String)cookie.getPath(), (String)"/idp");
        Assert.assertNull((Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((int)cookie.getMaxAge(), (int)0);
        StorageRecord record = this.storage.read(this.cm.getStorageContext(), "foo!jdoe");
        Assert.assertNull((Object)record);
    }

    @Test
    public void testCookieRestore() throws ComponentInitializationException, IOException {
        this.request.setContextPath("/idp");
        this.storage.create(this.cm.getStorageContext(), "foo!jdoe", "bar", Long.valueOf(Instant.now().plusSeconds(600L).toEpochMilli()));
        Assert.assertEquals((String)this.cm.getCookieValue("foo", "baz"), (String)"bar");
        Cookie cookie = this.response.getCookie("foo");
        assert (cookie != null);
        Assert.assertEquals((String)cookie.getValue(), (String)"bar");
        Assert.assertEquals((String)cookie.getPath(), (String)"/idp");
        Assert.assertNull((Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertTrue((cookie.getMaxAge() <= 600 ? 1 : 0) != 0);
    }
}

