/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.IdentifiedComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.webflow.execution.RequestContext;

public class ReloadServiceConfiguration
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String SERVICE_ID = "serviceId";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ReloadServiceConfiguration.class);
    @Nonnull
    private Function<ProfileRequestContext, ReloadableService<?>> serviceLookupStrategy = new WebFlowApplicationContextLookupStrategy();
    @NonnullBeforeExec
    private ReloadableService<?> service;

    public void setServiceLookupStrategy(@Nonnull Function<ProfileRequestContext, ReloadableService<?>> strategy) {
        this.checkSetterPreconditions();
        this.serviceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ReloadableService lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletResponse() == null) {
            this.log.debug("{} No HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.service = this.serviceLookupStrategy.apply(profileRequestContext);
        if (this.service == null) {
            this.log.warn("{} Unable to locate service to reload", (Object)this.getLogPrefix());
            try {
                HttpServletResponse response = this.getHttpServletResponse();
                assert (response != null);
                response.sendError(404, "Service not found.");
            }
            catch (IOException e) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String id = this.service instanceof AbstractIdentifiableInitializableComponent ? ((AbstractIdentifiableInitializableComponent)this.service).ensureId() : (this.service instanceof IdentifiedComponent ? ((IdentifiedComponent)this.service).getId() : "(unnamed)");
        this.log.debug("{} Reloading configuration for '{}'", (Object)this.getLogPrefix(), (Object)id);
        HttpServletResponse response = this.getHttpServletResponse();
        assert (response != null);
        try {
            this.service.reload();
            this.log.debug("{} Reloaded configuration for '{}'", (Object)this.getLogPrefix(), (Object)id);
            response.setStatus(200);
            response.getWriter().println("Configuration reloaded for '" + id + "'");
        }
        catch (ServiceException e) {
            this.log.error("{} Error reloading service configuration for '{}'", (Object)this.getLogPrefix(), (Object)id);
            try {
                response.sendError(500, e.getMessage());
            }
            catch (IOException e2) {
                this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e2);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    private class WebFlowApplicationContextLookupStrategy
    implements Function<ProfileRequestContext, ReloadableService<?>> {
        private WebFlowApplicationContextLookupStrategy() {
        }

        @Override
        @Nullable
        public ReloadableService<?> apply(@Nullable ProfileRequestContext input) {
            assert (input != null);
            SpringRequestContext springRequestContext = (SpringRequestContext)input.getSubcontext(SpringRequestContext.class);
            if (springRequestContext == null) {
                ReloadServiceConfiguration.this.log.warn("{} Spring request context not found in profile request context", (Object)ReloadServiceConfiguration.this.getLogPrefix());
                return null;
            }
            RequestContext requestContext = springRequestContext.getRequestContext();
            if (requestContext == null) {
                ReloadServiceConfiguration.this.log.warn("{} Web Flow request context not found in Spring request context", (Object)ReloadServiceConfiguration.this.getLogPrefix());
                return null;
            }
            String id = (String)requestContext.getFlowScope().get(ReloadServiceConfiguration.SERVICE_ID);
            if (id == null) {
                ReloadServiceConfiguration.this.log.warn("{} No {} flow variable found in request", (Object)ReloadServiceConfiguration.this.getLogPrefix(), (Object)ReloadServiceConfiguration.SERVICE_ID);
                return null;
            }
            try {
                Object bean = requestContext.getActiveFlow().getApplicationContext().getBean(id);
                if (bean != null && bean instanceof ReloadableService) {
                    return (ReloadableService)bean;
                }
            }
            catch (BeansException beansException) {
                // empty catch block
            }
            ReloadServiceConfiguration.this.log.warn("{} No bean of the correct type found named {}", (Object)ReloadServiceConfiguration.this.getLogPrefix(), (Object)id);
            return null;
        }
    }
}

