/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.profile.relyingparty.VerifiedProfileCriterion;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.criterion.ProfileRequestContextCriterion;
import org.slf4j.Logger;

public final class SelectRelyingPartyConfiguration
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectRelyingPartyConfiguration.class);
    @NonnullAfterInit
    private ReloadableService<RelyingPartyConfigurationResolver> rpConfigResolver;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @NonnullBeforeExec
    private RelyingPartyContext relyingPartyCtx;

    public void setRelyingPartyConfigurationResolver(@Nonnull ReloadableService<RelyingPartyConfigurationResolver> resolver) {
        this.checkSetterPreconditions();
        this.rpConfigResolver = (ReloadableService)Constraint.isNotNull(resolver, (String)"Relying party configuration resolver cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Nonnull
    private RelyingPartyContext getRelyingPartyCtx() {
        assert (this.isPreExecuteCalled());
        return this.relyingPartyCtx;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.rpConfigResolver == null) {
            throw new ComponentInitializationException("RelyingPartyConfigurationResolver cannot be null");
        }
    }

    public boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.relyingPartyCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.relyingPartyCtx == null) {
            this.log.debug("{} No relying party context available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        return true;
    }

    public void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try (ServiceableComponent resolver = this.rpConfigResolver.getServiceableComponent();){
            RelyingPartyConfiguration config;
            CriteriaSet criteria = new CriteriaSet();
            if (this.getRelyingPartyCtx().isVerified()) {
                criteria.add((Object)new VerifiedProfileCriterion(true));
            }
            if (this.getRelyingPartyCtx().getParent() == profileRequestContext) {
                criteria.add((Object)new ProfileRequestContextCriterion(profileRequestContext));
                config = (RelyingPartyConfiguration)((RelyingPartyConfigurationResolver)resolver.getComponent()).resolveSingle((Object)criteria);
            } else {
                ProfileRequestContext newPRC = new ProfileRequestContext();
                BaseContext originalParent = this.getRelyingPartyCtx().getParent();
                newPRC.addSubcontext((BaseContext)this.getRelyingPartyCtx());
                criteria.add((Object)new ProfileRequestContextCriterion(newPRC));
                config = (RelyingPartyConfiguration)((RelyingPartyConfigurationResolver)resolver.getComponent()).resolveSingle((Object)criteria);
                if (originalParent != null) {
                    originalParent.addSubcontext((BaseContext)this.getRelyingPartyCtx());
                }
            }
            if (config == null) {
                this.log.debug("{} No relying party configuration applies to this request", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
                return;
            }
            this.log.debug("{} Found relying party configuration {} for request", (Object)this.getLogPrefix(), (Object)config.getId());
            this.getRelyingPartyCtx().setConfiguration(config);
        }
        catch (ResolverException e) {
            this.log.error("{} Error trying to resolve relying party configuration", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
        }
        catch (ServiceException e) {
            this.log.error("{} Invalid relying party configuration", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
        }
    }
}

