/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.AbstractProfileInterceptorAction;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SelectProfileInterceptorFlow
extends AbstractProfileInterceptorAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectProfileInterceptorFlow.class);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        if (!super.doPreExecute(profileRequestContext, interceptorContext)) {
            return false;
        }
        ProfileInterceptorFlowDescriptor attemptedFlow = interceptorContext.getAttemptedFlow();
        if (attemptedFlow != null) {
            this.log.debug("{} Moving completed flow {} to completed set, selecting next one", (Object)this.getLogPrefix(), (Object)attemptedFlow.getId());
            interceptorContext.getAvailableFlows().remove(attemptedFlow.getId());
            interceptorContext.setAttemptedFlow(null);
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        ProfileInterceptorFlowDescriptor flow = this.selectUnattemptedFlow(profileRequestContext, interceptorContext);
        if (flow == null) {
            this.log.debug("{} No flows available to choose from", (Object)this.getLogPrefix());
            return;
        }
        this.log.debug("{} Selecting flow {}", (Object)this.getLogPrefix(), (Object)flow.ensureId());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)flow.ensureId());
    }

    @Nullable
    private ProfileInterceptorFlowDescriptor selectUnattemptedFlow(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        for (ProfileInterceptorFlowDescriptor flow : interceptorContext.getAvailableFlows().values()) {
            this.log.debug("{} Checking flow {} for applicability...", (Object)this.getLogPrefix(), (Object)flow.getId());
            if (flow.test(profileRequestContext)) {
                interceptorContext.setAttemptedFlow(flow);
                return flow;
            }
            this.log.debug("{} Flow {} was not applicable to this request", (Object)this.getLogPrefix(), (Object)flow.getId());
        }
        return null;
    }
}

