/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.ChainingMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.MetadataNamespaceHandler;
import net.shibboleth.idp.profile.spring.relyingparty.security.SecurityNamespaceHandler;
import net.shibboleth.idp.saml.metadata.impl.RelyingPartyMetadataProvider;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractMetadataProviderParser
extends AbstractSingleBeanDefinitionParser {
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataProviderParser.class);

    private boolean isPresentNotChaining(@Nonnull Element element, @Nonnull String attribute) {
        if (!element.hasAttributeNS(null, attribute)) {
            return false;
        }
        if (ChainingMetadataProviderParser.ELEMENT_NAME.equals(DOMTypeSupport.getXSIType((Element)element))) {
            this.log.warn("{} is not valid for {}", (Object)attribute, (Object)ChainingMetadataProviderParser.ELEMENT_NAME.getLocalPart());
            return false;
        }
        return true;
    }

    private boolean isOuterElement(@Nonnull Element element) {
        return element.getParentNode().getNodeType() == 9;
    }

    protected abstract Class<? extends MetadataResolver> getNativeBeanClass(Element var1);

    protected final Class<? extends MetadataResolver> getBeanClass(Element element) {
        if (this.isOuterElement(element)) {
            return RelyingPartyMetadataProvider.class;
        }
        return this.getNativeBeanClass(element);
    }

    protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        if (this.isOuterElement(element)) {
            BeanDefinitionBuilder childBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getNativeBeanClass(element));
            this.doNativeParse(element, parserContext, childBeanDefinitionBuilder);
            builder.addConstructorArgValue((Object)childBeanDefinitionBuilder.getBeanDefinition());
        } else {
            this.doNativeParse(element, parserContext, builder);
        }
    }

    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        builder.setLazyInit(true);
        builder.addPropertyValue("id", (Object)element.getAttributeNS(null, "id"));
        if (this.isPresentNotChaining(element, "failFastInitialization")) {
            builder.addPropertyValue("failFastInitialization", (Object)element.getAttributeNS(null, "failFastInitialization"));
        }
        if (this.isPresentNotChaining(element, "requireValidMetadata")) {
            builder.addPropertyValue("requireValidMetadata", (Object)element.getAttributeNS(null, "requireValidMetadata"));
        }
        if (element.hasAttributeNS(null, "maxCacheDuration")) {
            this.log.error("{}: maxCacheDuration is not supported", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("maxCacheDuration is not supported", new Location(parserContext.getReaderContext().getResource())));
        }
        if (element.hasAttributeNS(null, "cacheDuration")) {
            this.log.error("{}: cacheDuration is not supported", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("cacheDuration is not supported", new Location(parserContext.getReaderContext().getResource())));
        }
        if (element.hasAttributeNS(null, "maintainExpiredMetadata")) {
            this.log.error("{}: maintainExpiredMetadata is not supported", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("maintainExpiredMetadata is not supported", new Location(parserContext.getReaderContext().getResource())));
        }
        List filters = ElementSupport.getChildElements((Node)element, (QName)MetadataNamespaceHandler.METADATA_FILTER_ELEMENT_NAME);
        if (null != filters && !filters.isEmpty()) {
            builder.addPropertyValue("metadataFilter", (Object)SpringSupport.parseCustomElements((Collection)filters, (ParserContext)parserContext));
        }
        List trustEngines = ElementSupport.getChildElements((Node)element, (QName)SecurityNamespaceHandler.TRUST_ENGINE_ELEMENT_NAME);
        SpringSupport.parseCustomElements((Collection)trustEngines, (ParserContext)parserContext);
    }
}

