/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractMetadataProviderParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractReloadingMetadataProviderParser
extends AbstractMetadataProviderParser {
    private static final String DEFAULT_PARSER_POOL_REF = "shibboleth.ParserPool";
    private static final String DEFAULT_TIMER_REF = "shibboleth.TaskTimer";
    private static final String DEFAULT_DELAY_FACTOR = "0.75";

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        builder.addConstructorArgReference(this.getTaskTimerRef(element));
        if (element.hasAttributeNS(null, "refreshDelayFactor")) {
            builder.addPropertyValue("refreshDelayFactor", (Object)element.getAttributeNS(null, "refreshDelayFactor"));
        } else {
            builder.addPropertyValue("refreshDelayFactor", (Object)DEFAULT_DELAY_FACTOR);
        }
        if (element.hasAttributeNS(null, "maxRefreshDelay")) {
            builder.addPropertyValue("maxRefreshDelay", (Object)element.getAttributeNS(null, "maxRefreshDelay"));
        }
        if (element.hasAttributeNS(null, "minRefreshDelay")) {
            builder.addPropertyValue("minRefreshDelay", (Object)element.getAttributeNS(null, "minRefreshDelay"));
        }
        builder.addPropertyReference("parserPool", this.getParserPoolRef(element));
    }

    protected String getTaskTimerRef(Element element) {
        String taskTimerRef = null;
        if (element.hasAttributeNS(null, "taskTimerRef")) {
            taskTimerRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "taskTimerRef"));
        }
        if (taskTimerRef == null) {
            taskTimerRef = DEFAULT_TIMER_REF;
        }
        return taskTimerRef;
    }

    protected String getParserPoolRef(Element element) {
        String parserPoolRef = null;
        if (element.hasAttributeNS(null, "parserPoolRef")) {
            parserPoolRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "parserPoolRef"));
        }
        if (parserPoolRef == null) {
            parserPoolRef = DEFAULT_PARSER_POOL_REF;
        }
        return parserPoolRef;
    }
}

