/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractReloadingMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.HttpClientFactoryBean;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class HTTPMetadataProviderParser
extends AbstractReloadingMetadataProviderParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "HTTPMetadataProvider");
    private static final String METADATA_URL = "metadataURL";
    private static final String BASIC_AUTH_USER = "basicAuthUser";
    private static final String BASIC_AUTH_PASSWORD = "basicAuthPassword";

    protected Class<? extends HTTPMetadataResolver> getNativeBeanClass(Element element) {
        return HTTPMetadataResolver.class;
    }

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        builder.addConstructorArgValue((Object)this.buildHttpClient(element));
        builder.addConstructorArgValue((Object)element.getAttributeNS(null, METADATA_URL));
        if (element.hasAttributeNS(null, BASIC_AUTH_USER) || element.hasAttributeNS(null, BASIC_AUTH_PASSWORD)) {
            builder.addPropertyValue("basicCredentials", (Object)this.buildBasicCredentials(element));
        }
    }

    private BeanDefinition buildHttpClient(Element element) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientFactoryBean.class);
        builder.setLazyInit(true);
        if (element.hasAttributeNS(null, "requestTimeout")) {
            builder.addPropertyValue("connectionTimeout", (Object)element.getAttributeNS(null, "requestTimeout"));
        }
        if (element.hasAttributeNS(null, "disregardSslCertificate")) {
            builder.addPropertyValue("connectionDisregardSslCertificate", (Object)element.getAttributeNS(null, "disregardSslCertificate"));
        }
        if (element.hasAttributeNS(null, "proxyHost")) {
            builder.addPropertyValue("connectionProxyHost", (Object)element.getAttributeNS(null, "proxyHost"));
        }
        if (element.hasAttributeNS(null, "proxyPort")) {
            builder.addPropertyValue("connectionProxyPort", (Object)element.getAttributeNS(null, "proxyPort"));
        }
        if (element.hasAttributeNS(null, "proxyUser")) {
            builder.addPropertyValue("connectionProxyUsername", (Object)element.getAttributeNS(null, "proxyUser"));
        }
        if (element.hasAttributeNS(null, "proxyPassword")) {
            builder.addPropertyValue("connectionProxyPassword", (Object)element.getAttributeNS(null, "proxyPassword"));
        }
        return builder.getBeanDefinition();
    }

    private BeanDefinition buildBasicCredentials(Element element) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(UsernamePasswordCredentials.class);
        builder.setLazyInit(true);
        builder.addConstructorArgValue((Object)element.getAttributeNS(null, BASIC_AUTH_USER));
        builder.addConstructorArgValue((Object)element.getAttributeNS(null, BASIC_AUTH_PASSWORD));
        return builder.getBeanDefinition();
    }
}

