/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.saml;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.saml.profile.config.BasicSAMLArtifactConfiguration;
import net.shibboleth.idp.saml.profile.config.logic.LegacyEncryptionRequirementPredicate;
import net.shibboleth.idp.saml.profile.config.logic.LegacySigningRequirementPredicate;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseSAMLProfileConfigurationParser
extends AbstractSingleBeanDefinitionParser {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BaseSAMLProfileConfigurationParser.class);
    private boolean artifactAware;
    private BeanFactory embeddedBeans;

    protected void setArtifactAware(boolean flag) {
        this.artifactAware = flag;
    }

    @Nullable
    protected BeanFactory getEmbeddedBeans() {
        return this.embeddedBeans;
    }

    @Nullable
    protected BeanDefinition getArtifactConfiguration(Element element) {
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(BasicSAMLArtifactConfiguration.class);
        if (element.hasAttributeNS(null, "artifactType")) {
            definition.addPropertyValue("artifactType", (Object)element.getAttributeNS(null, "artifactType"));
        }
        if (element.hasAttributeNS(null, "artifactResolutionServiceURL")) {
            definition.addPropertyValue("artifactResolutionServiceURL", (Object)element.getAttributeNS(null, "artifactResolutionServiceURL"));
        }
        if (element.hasAttributeNS(null, "artifactResolutionServiceIndex")) {
            definition.addPropertyValue("artifactResolutionServiceIndex", (Object)element.getAttributeNS(null, "artifactResolutionServiceIndex"));
        } else {
            definition.addPropertyReference("artifactResolutionServiceIndex", this.getProfileBeanNamePrefix() + "ArtifactServiceIndex");
        }
        return definition.getBeanDefinition();
    }

    @Nonnull
    private BeanDefinition predicateFor(@Nullable String value, Class<? extends Predicate> claz) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(claz);
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)value));
        return builder.getBeanDefinition();
    }

    @Nonnull
    protected BeanDefinition predicateForSigning(@Nullable String value) {
        return this.predicateFor(value, LegacySigningRequirementPredicate.class);
    }

    @Nonnull
    protected BeanDefinition predicateForEncryption(@Nullable String value) {
        return this.predicateFor(value, LegacyEncryptionRequirementPredicate.class);
    }

    protected List<String> getAudiences(Element element) {
        List audienceElems = ElementSupport.getChildElementsByTagNameNS((Node)element, (String)"urn:mace:shibboleth:2.0:relying-party:saml", (String)"Audience");
        return SpringSupport.getElementTextContentAsManagedList((Collection)audienceElems);
    }

    private void setSecurityConfiguration(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        String credentialRef;
        if (null != this.getEmbeddedBeans()) {
            SecurityConfiguration configuration = (SecurityConfiguration)SpringSupport.getBean((BeanFactory)this.getEmbeddedBeans(), SecurityConfiguration.class);
            if (null != configuration) {
                builder.addPropertyValue("securityConfiguration", (Object)configuration);
                if (element.hasAttributeNS(null, "signingCredentialRef")) {
                    this.log.warn("local beans defined, explicit signingCredentialRef is ignored");
                }
                return;
            }
            this.log.debug("embedded beans but no SecurityConfiguration");
        }
        if (element.hasAttributeNS(null, "signingCredentialRef")) {
            credentialRef = element.getAttributeNS(null, "signingCredentialRef");
            this.log.debug("using explicit signing credential reference {}", (Object)credentialRef);
        } else {
            this.log.debug("Looking for default signing credential reference");
            Node parentNode = element.getParentNode();
            if (parentNode == null) {
                this.log.debug("no parent to ProfileConfiguration, no defaultSigningCredential set");
                return;
            }
            if (!(parentNode instanceof Element)) {
                this.log.debug("parent of ProfileConfiguration was unrecognizable, no defaultSigningCredential set");
                return;
            }
            Element relyingParty = (Element)parentNode;
            if (!relyingParty.hasAttributeNS(null, "defaultSigningCredentialRef")) {
                return;
            }
            credentialRef = relyingParty.getAttributeNS(null, "defaultSigningCredentialRef");
            this.log.debug("Using default signing credential reference {}", (Object)credentialRef);
        }
        BeanDefinitionBuilder signingConfiguration = BeanDefinitionBuilder.genericBeanDefinition(BasicSignatureSigningConfiguration.class);
        signingConfiguration.addPropertyReference("signingCredentials", credentialRef);
        BeanDefinitionBuilder configuration = BeanDefinitionBuilder.genericBeanDefinition(SecurityConfiguration.class);
        configuration.addPropertyValue("signatureSigningConfiguration", (Object)signingConfiguration.getBeanDefinition());
        builder.addPropertyValue("securityConfiguration", (Object)configuration.getBeanDefinition());
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        List springBeans = ElementSupport.getChildElements((Node)element, (QName)SpringSupport.SPRING_BEANS_ELEMENT_NAME);
        if (null != springBeans && !springBeans.isEmpty()) {
            this.embeddedBeans = SpringSupport.createBeanFactory((Element)((Element)springBeans.get(0)));
        }
        this.setSecurityConfiguration(element, builder, parserContext);
        if (element.hasAttributeNS(null, "assertionLifetime")) {
            builder.addPropertyValue("assertionLifetime", (Object)element.getAttributeNS(null, "assertionLifetime"));
        }
        if (element.hasAttributeNS(null, "includeConditionsNotBefore")) {
            builder.addPropertyValue("includeConditionsNotBefore", (Object)element.getAttributeNS(null, "includeConditionsNotBefore"));
        }
        if (this.artifactAware) {
            builder.addPropertyValue("artifactConfiguration", (Object)this.getArtifactConfiguration(element));
        }
        if (element.hasAttributeNS(null, "attributeAuthority")) {
            this.log.warn("Deprecated attribute 'attributeAuthority=\"{}\"' has been ignored", (Object)element.getAttributeNS(null, "attributeAuthority"));
        }
        if (element.hasAttributeNS(null, "securityPolicyRef")) {
            this.log.warn("Deprecated attribute 'securityPolicyRef=\"{}\"' has been ignored", (Object)element.getAttributeNS(null, "securityPolicyRef"));
        }
        if (element.hasAttributeNS(null, "outboundArtifactType")) {
            this.log.warn("Deprecated attribute 'outboundArtifactType=\"{}\"' has been ignored", (Object)element.getAttributeNS(null, "outboundArtifactType"));
        }
        if (element.hasAttributeNS(null, "inboundFlowId")) {
            builder.addPropertyValue("inboundSubflowId", (Object)element.getAttributeNS(null, "inboundFlowId"));
        } else {
            builder.addPropertyReference("inboundSubflowId", this.getProfileBeanNamePrefix() + "InboundFlowId");
        }
        builder.addPropertyValue("outboundSubflowId", (Object)element.getAttributeNS(null, "outboundFlowId"));
        if (element.hasAttributeNS(null, "signAssertions")) {
            builder.addPropertyValue("signAssertions", (Object)this.predicateForSigning(element.getAttributeNS(null, "signAssertions")));
        }
        if (element.hasAttributeNS(null, "signRequests")) {
            builder.addPropertyValue("signRequests", (Object)this.predicateForSigning(element.getAttributeNS(null, "signRequests")));
        }
        if (element.hasAttributeNS(null, "signResponses")) {
            builder.addPropertyValue("signResponses", (Object)this.predicateForSigning(element.getAttributeNS(null, "signResponses")));
        }
        builder.addPropertyValue("additionalAudienceForAssertion", this.getAudiences(element));
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected abstract String getProfileBeanNamePrefix();
}

