/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.saml;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.spring.relyingparty.saml.BaseSAMLProfileConfigurationParser;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.saml1.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ShibbolethSSOProfileParser
extends BaseSAMLProfileConfigurationParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:relying-party:saml", "ShibbolethSSOProfile");
    private Logger log = LoggerFactory.getLogger(ShibbolethSSOProfileParser.class);

    public ShibbolethSSOProfileParser() {
        this.setArtifactAware(true);
    }

    protected Class<? extends BrowserSSOProfileConfiguration> getBeanClass(Element element) {
        return BrowserSSOProfileConfiguration.class;
    }

    @Override
    protected String getProfileBeanNamePrefix() {
        return "shibboleth.SAML1.BrowserSSO.";
    }

    private void setAuthnProfileFromRelyingParty(@Nonnull Element element, @Nonnull BeanDefinitionBuilder builder) {
        Node parentNode = element.getParentNode();
        if (parentNode == null) {
            this.log.warn("no parent to ProfileConfiguration, no defaultAuthenticationMethod set");
            return;
        }
        if (!(parentNode instanceof Element)) {
            this.log.warn("parent of ProfileConfiguration was unrecognizable, no defaultAuthenticationMethod set");
            return;
        }
        Element parent = (Element)parentNode;
        if (parent.hasAttributeNS(null, "defaultAuthenticationMethod")) {
            String method = StringSupport.trimOrNull((String)parent.getAttributeNS(null, "defaultAuthenticationMethod"));
            if (null == method) {
                return;
            }
            BeanDefinitionBuilder methodBuilder = BeanDefinitionBuilder.genericBeanDefinition(AuthenticationMethodPrincipal.class);
            methodBuilder.addConstructorArgValue((Object)method);
            ManagedList methodsList = new ManagedList(1);
            methodsList.add(methodBuilder.getBeanDefinition());
            builder.addPropertyValue("defaultAuthenticationMethods", (Object)methodBuilder.getBeanDefinition());
        }
        if (parent.hasAttributeNS(null, "nameIDFormatPrecedence")) {
            List nameIDs = AttributeSupport.getAttributeValueAsList((Attr)parent.getAttributeNodeNS(null, "nameIDFormatPrecedence"));
            ManagedList managedNameIds = new ManagedList(nameIDs.size());
            managedNameIds.addAll(nameIDs);
            builder.addPropertyValue("nameIDFormatPrecedence", (Object)managedNameIds);
        }
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "localityAddress")) {
            this.log.error("Deprecated attribute 'localityAddress' is being ignored");
            throw new BeanDefinitionParsingException(new Problem("Deprecated attribute 'localityAddress' is being ignored", new Location(parserContext.getReaderContext().getResource())));
        }
        if (element.hasAttributeNS(null, "localityDNSName")) {
            this.log.error("Deprecated attribute 'localityDNSName' is being ignored");
            throw new BeanDefinitionParsingException(new Problem("Deprecated attribute 'localityDNSName' is being ignored", new Location(parserContext.getReaderContext().getResource())));
        }
        if (element.hasAttributeNS(null, "includeAttributeStatement")) {
            builder.addPropertyValue("includeAttributeStatement", (Object)element.getAttributeNS(null, "includeAttributeStatement"));
        }
        this.setAuthnProfileFromRelyingParty(element, builder);
    }
}

