/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.credential;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.spring.relyingparty.security.credential.AbstractCredentialParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractBasicCredentialParser
extends AbstractCredentialParser {
    public static final QName PRIVATE_KEY_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:security", "PrivateKey");
    public static final QName PUBLIC_KEY_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:security", "PublicKey");
    public static final QName SECRET_KEY_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:security", "SecretKey");
    private final Logger log = LoggerFactory.getLogger(AbstractBasicCredentialParser.class);

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        builder.addPropertyValue("configDescription", (Object)parserContext.getReaderContext().getResource().getDescription());
        this.parsePrivateKey(ElementSupport.getChildElements((Node)element, (QName)PRIVATE_KEY_ELEMENT_NAME), parserContext, builder);
        this.parsePublicKey(ElementSupport.getChildElements((Node)element, (QName)PUBLIC_KEY_ELEMENT_NAME), parserContext, builder);
        this.parseSecretKey(ElementSupport.getChildElements((Node)element, (QName)SECRET_KEY_ELEMENT_NAME), parserContext, builder);
    }

    private void parsePrivateKey(@Nullable List<Element> childElements, ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        if (null == childElements || childElements.isEmpty()) {
            return;
        }
        if (childElements.size() > 1) {
            this.log.error("{}: More than one <PrivateKey> Elements present.", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("More than one <PrivateKey> Elements present.");
        }
        Element key = childElements.get(0);
        String value = StringSupport.trimOrNull((String)key.getTextContent());
        if (null == value) {
            this.log.error("{}: <PrivateKey> Must contain text.", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("<PrivateKey> Must contain text.");
        }
        this.log.debug("Found a private key <Supressed>");
        builder.addPropertyValue("privateKeyInfo", (Object)value);
        builder.addPropertyValue("privateKeyPassword", (Object)key.getAttributeNS(null, "password"));
    }

    private void parsePublicKey(@Nullable List<Element> childElements, ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        if (null == childElements || childElements.isEmpty()) {
            return;
        }
        if (childElements.size() > 1) {
            this.log.error("{}: More than one <PublicKey> elements present.", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("More than one <PublicKey> elements present.");
        }
        Element key = childElements.get(0);
        String value = StringSupport.trimOrNull((String)key.getTextContent());
        if (null == value) {
            this.log.error("{}: <PublicKey> Must contain text.", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("<PublicKey> Must contain text.");
        }
        this.log.debug("Found a public key {}", (Object)value);
        builder.addPropertyValue("publicKeyInfo", (Object)value);
        if (key.hasAttributeNS(null, "password")) {
            this.log.warn("password on public key is ignored");
        }
    }

    private void parseSecretKey(@Nullable List<Element> childElements, ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        if (null == childElements || childElements.isEmpty()) {
            return;
        }
        if (childElements.size() > 1) {
            this.log.error("{}: More than one <SecretKey> Elements present.", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("More than one <SecretKey> Elements present.");
        }
        this.log.warn("<SecretKey> is not supported");
        Element key = childElements.get(0);
        String value = StringSupport.trimOrNull((String)key.getTextContent());
        if (null == value) {
            this.log.error("{}: <SecretKey> Must contain text.", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("<SecretKey> Must contain text.");
        }
        this.log.debug("Found a secret key <Supressed>");
        builder.addPropertyValue("secretKeyInfo", (Object)value);
        builder.addPropertyValue("secretKeyPassword", (Object)key.getAttributeNS(null, "password"));
    }
}

