/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.trustengine;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.spring.relyingparty.security.trustengine.AbstractTrustEngineParser;
import net.shibboleth.idp.profile.spring.relyingparty.security.trustengine.PKIXValidationOptionsParser;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.security.x509.impl.BasicX509CredentialNameEvaluator;
import org.opensaml.security.x509.impl.CertPathPKIXTrustEvaluator;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.opensaml.xmlsec.config.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.signature.support.impl.PKIXSignatureTrustEngine;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StaticPKIXSignatureParser
extends AbstractTrustEngineParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:security", "StaticPKIXSignature");
    public static final QName VALIDATION_INFO = new QName("urn:mace:shibboleth:2.0:security", "ValidationInfo");
    public static final QName TRUSTED_NAMES = new QName("urn:mace:shibboleth:2.0:security", "TrustedName");

    protected Class<?> getBeanClass(Element element) {
        return PKIXSignatureTrustEngine.class;
    }

    private BeanDefinition getPKIXValidationInformationResolver(Element element, @Nonnull ParserContext parserContext) {
        List validationInfoElements = ElementSupport.getChildElements((Node)element, (QName)VALIDATION_INFO);
        List trustedNameElements = ElementSupport.getChildElements((Node)element, (QName)TRUSTED_NAMES);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticPKIXValidationInformationResolver.class);
        builder.addConstructorArgValue((Object)SpringSupport.parseCustomElements((Collection)validationInfoElements, (ParserContext)parserContext));
        builder.addConstructorArgValue((Object)SpringSupport.getElementTextContentAsManagedList((Collection)trustedNameElements));
        return builder.getBeanDefinition();
    }

    private BeanDefinition getPKIXTrustEvaluator(Element element, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CertPathPKIXTrustEvaluator.class);
        List validationOptionsElements = ElementSupport.getChildElements((Node)element, (QName)PKIXValidationOptionsParser.ELEMENT_NAME);
        if (null != validationOptionsElements && !validationOptionsElements.isEmpty()) {
            builder.addConstructorArgValue((Object)SpringSupport.parseCustomElements((Collection)validationOptionsElements, (ParserContext)parserContext));
        }
        return builder.getBeanDefinition();
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        builder.addConstructorArgValue((Object)this.getPKIXValidationInformationResolver(element, parserContext));
        builder.addConstructorArgValue((Object)DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
        builder.addConstructorArgValue((Object)this.getPKIXTrustEvaluator(element, parserContext));
        builder.addConstructorArgValue((Object)new BasicX509CredentialNameEvaluator());
    }
}

