/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.resource;

import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.BaseSpringNamespaceHandler;
import net.shibboleth.idp.profile.spring.resource.ClasspathResourceParser;
import net.shibboleth.idp.profile.spring.resource.SVNResourceParser;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceNamespaceHandler
extends BaseSpringNamespaceHandler {
    public static final String NAMESPACE = "urn:mace:shibboleth:2.0:resource";
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resource", "Resource");
    public static final QName FILTER_NAME = new QName("urn:mace:shibboleth:2.0:resource", "ResourceFilter");
    public static final QName FILESYSTEM_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resource", "FilesystemResource");
    public static final QName HTTP_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resource", "HttpResource");
    public static final QName FILE_HTTP_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resource", "FileBackedHttpResource");
    private static final Logger LOG = LoggerFactory.getLogger(ResourceNamespaceHandler.class);

    public void init() {
        this.registerBeanDefinitionParser(ClasspathResourceParser.ELEMENT_NAME, (BeanDefinitionParser)new ClasspathResourceParser());
        this.registerBeanDefinitionParser(SVNResourceParser.ELEMENT_NAME, (BeanDefinitionParser)new SVNResourceParser());
    }

    public static void noFilters(Element resourceElement, XmlReaderContext readerContext) {
        List filters = ElementSupport.getChildElements((Node)resourceElement, (QName)FILTER_NAME);
        if (null == filters || filters.isEmpty()) {
            return;
        }
        LOG.error("{}: Resource filters are not supported", (Object)readerContext.getResource().getDescription());
        throw new BeanDefinitionParsingException(new Problem("Resource filters are not supported", new Location(readerContext.getResource())));
    }
}

