/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.mapping;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAMLAttributeValueMapper
extends AbstractInitializableComponent {
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLAttributeValueMapper.class);
    private String logPrefix;

    @Nonnull
    @Unmodifiable
    public List<IdPAttributeValue<?>> decodeValues(@Nonnull @NonnullElements List<XMLObject> inputs) {
        ArrayList<IdPAttributeValue> outputs = new ArrayList<IdPAttributeValue>(inputs.size());
        for (XMLObject input : inputs) {
            IdPAttributeValue output = this.decodeValue(input);
            if (null == output) continue;
            outputs.add(output);
        }
        return Collections.unmodifiableList(outputs);
    }

    @Nullable
    protected String getStringValue(@Nonnull XMLObject object) {
        String retVal = null;
        if (object instanceof XSString) {
            retVal = ((XSString)object).getValue();
        } else if (object instanceof XSURI) {
            retVal = ((XSURI)object).getValue();
        } else if (object instanceof XSBoolean) {
            retVal = ((XSBoolean)object).getValue().getValue() != false ? "1" : "0";
        } else if (object instanceof XSInteger) {
            retVal = ((XSInteger)object).getValue().toString();
        } else if (object instanceof XSDateTime) {
            DateTime dt = ((XSDateTime)object).getValue();
            retVal = dt != null ? ((XSDateTime)object).getDateTimeFormatter().print((ReadableInstant)dt) : null;
        } else if (object instanceof XSBase64Binary) {
            retVal = ((XSBase64Binary)object).getValue();
        } else if (object instanceof XSAny) {
            XSAny wc = (XSAny)object;
            retVal = wc.getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty() ? wc.getTextContent() : null;
        }
        if (null == retVal) {
            this.log.info("{} value of type {} could not be converted", (Object)this.getLogPrefix(), (Object)object.getClass().toString());
        }
        return retVal;
    }

    @NonnullAfterInit
    public String getLogPrefix() {
        return this.logPrefix;
    }

    public void setLogPrefix(@Nonnull String prefix) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.logPrefix = (String)Constraint.isNotNull((Object)prefix, (String)"prefix can not be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.logPrefix) {
            throw new ComponentInitializationException("No log prefix set");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractSAMLAttributeValueMapper) {
            AbstractSAMLAttributeValueMapper other = (AbstractSAMLAttributeValueMapper)((Object)obj);
            return ((Object)((Object)this)).getClass().equals(((Object)((Object)other)).getClass());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{((Object)((Object)this)).getClass()});
    }

    @Nullable
    protected abstract IdPAttributeValue decodeValue(@Nonnull XMLObject var1);

    @Nonnull
    protected abstract String getAttributeTypeName();
}

