/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.idwsf.profile.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;

public class SSOSProfileConfiguration
extends BrowserSSOProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/liberty/ssos";
    @NonNegative
    private long maximumTokenDelegationChainLength = 0L;
    @Nonnull
    private Predicate<ProfileRequestContext<RequestAbstractType, Response>> delegationPredicate = Predicates.alwaysFalse();

    public SSOSProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected SSOSProfileConfiguration(String profileId) {
        super(profileId);
    }

    public long getMaximumTokenDelegationChainLength() {
        return this.maximumTokenDelegationChainLength;
    }

    public void setMaximumTokenDelegationChainLength(long length) {
        this.maximumTokenDelegationChainLength = Constraint.isGreaterThanOrEqual((long)0L, (long)length, (String)"Delegation chain length must be greater than or equal to 0");
    }

    @Nonnull
    public Predicate<ProfileRequestContext<RequestAbstractType, Response>> getDelegationPredicate() {
        return this.delegationPredicate;
    }

    public void setDelegationPredicate(@Nonnull Predicate<ProfileRequestContext<RequestAbstractType, Response>> predicate) {
        this.delegationPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Delegation predicate cannot be null");
    }
}

