/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAMLAttributeEncoder<AttributeType extends SAMLObject, EncodedType extends IdPAttributeValue>
extends AbstractInitializableComponent
implements AttributeEncoder<AttributeType>,
UnmodifiableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLAttributeEncoder.class);
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();
    @NonnullAfterInit
    private String name;
    private boolean encodeType = true;

    @Nonnull
    public Predicate<ProfileRequestContext> getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition cannot be null");
    }

    @NonnullAfterInit
    public final String getName() {
        return this.name;
    }

    public void setName(@Nonnull @NotEmpty String attributeName) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.name = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeName), (String)"Attribute name cannot be null or empty");
    }

    public boolean encodeType() {
        return this.encodeType;
    }

    public void setEncodeType(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encodeType = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.name == null) {
            throw new ComponentInitializationException("Attribute name cannot be null or empty");
        }
    }

    @Nonnull
    public AttributeType encode(@Nonnull IdPAttribute attribute) throws AttributeEncodingException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)attribute, (String)"Attribute to encode cannot be null");
        String attributeId = attribute.getId();
        this.log.debug("Beginning to encode attribute {}", (Object)attributeId);
        if (attribute.getValues().isEmpty()) {
            throw new AttributeEncodingException("Unable to encode " + attributeId + " attribute.  It does not contain any values");
        }
        ArrayList<XMLObject> samlAttributeValues = new ArrayList<XMLObject>();
        for (IdPAttributeValue o : attribute.getValues()) {
            if (o == null) {
                this.log.debug("Skipping null value of attribute {}", (Object)attributeId);
                continue;
            }
            if (!this.canEncodeValue(attribute, o)) {
                this.log.debug("Skipping value of attribute {}; Type {} cannot be encoded by this encoder.", (Object)attributeId, (Object)o.getClass().getName());
                continue;
            }
            IdPAttributeValue attributeValue = o;
            XMLObject samlAttributeValue = this.encodeValue(attribute, attributeValue);
            if (samlAttributeValue == null) {
                this.log.debug("Skipping empty value for attribute {}", (Object)attributeId);
                continue;
            }
            samlAttributeValues.add(samlAttributeValue);
        }
        if (samlAttributeValues.isEmpty()) {
            throw new AttributeEncodingException("Attribute " + attributeId + " did not contain any encodeable values");
        }
        this.log.debug("Completed encoding {} values for attribute {}", (Object)samlAttributeValues.size(), (Object)attributeId);
        return this.buildAttribute(attribute, samlAttributeValues);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractSAMLAttributeEncoder)) {
            return false;
        }
        AbstractSAMLAttributeEncoder other = (AbstractSAMLAttributeEncoder)((Object)obj);
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getProtocol(), other.getProtocol());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getName(), this.getProtocol()});
    }

    protected abstract boolean canEncodeValue(@Nonnull IdPAttribute var1, @Nonnull IdPAttributeValue var2);

    @Nullable
    protected abstract XMLObject encodeValue(@Nonnull IdPAttribute var1, @Nonnull EncodedType var2) throws AttributeEncodingException;

    @Nonnull
    protected abstract AttributeType buildAttribute(@Nonnull IdPAttribute var1, @Nonnull @NonnullElements List<XMLObject> var2) throws AttributeEncodingException;
}

