/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.authn.principal;

import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.NameID;
import org.w3c.dom.Node;

public class NameIDPrincipal
implements CloneablePrincipal {
    @Nonnull
    private NameID nameID;
    @Nonnull
    @NotEmpty
    private String name;

    public NameIDPrincipal(@Nonnull NameID theNameID) {
        this.nameID = (NameID)Constraint.isNotNull((Object)theNameID, (String)"Supplied NameID cannot be null");
        try {
            this.name = SerializeSupport.nodeToString((Node)((Marshaller)Constraint.isNotNull((Object)XMLObjectSupport.getMarshaller((XMLObject)theNameID), (String)"No marshaller for NameId")).marshall((XMLObject)theNameID));
        }
        catch (MarshallingException e) {
            throw new XMLRuntimeException((Exception)((Object)e));
        }
    }

    public String getName() {
        return this.name;
    }

    @Nonnull
    public NameID getNameID() {
        return this.nameID;
    }

    public int hashCode() {
        return this.nameID.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof NameIDPrincipal) {
            return this.nameID.equals(((NameIDPrincipal)other).getNameID());
        }
        return false;
    }

    public NameIDPrincipal clone() throws CloneNotSupportedException {
        NameIDPrincipal copy = (NameIDPrincipal)super.clone();
        try {
            copy.nameID = (NameID)XMLObjectSupport.cloneXMLObject((XMLObject)this.nameID, (XMLObjectSupport.CloneOutputOption)XMLObjectSupport.CloneOutputOption.RootDOMInNewDocument);
            copy.name = SerializeSupport.nodeToString((Node)((Marshaller)Constraint.isNotNull((Object)XMLObjectSupport.getMarshaller((XMLObject)copy.nameID), (String)"No marshaller for nameID")).marshall((XMLObject)copy.nameID));
        }
        catch (MarshallingException | UnmarshallingException e) {
            throw new XMLRuntimeException((Exception)e);
        }
        return copy;
    }
}

