/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class NameIDCanonicalizationFlowDescriptor
extends SubjectCanonicalizationFlowDescriptor {
    @NonnullAfterInit
    @Unmodifiable
    private Set<String> formats;

    @Nonnull
    public Collection<String> getFormats() {
        return this.formats;
    }

    public void setFormats(@Nonnull Collection<String> theFormats) {
        Constraint.isNotNull(theFormats, (String)"Format list must be non null");
        Constraint.isNotEmpty(theFormats, (String)"Format list must be non empty");
        HashSet newFormats = new HashSet(theFormats.size());
        CollectionSupport.addIf(newFormats, theFormats, (Predicate)Predicates.notNull());
        this.formats = ImmutableSet.copyOf(newFormats);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.formats || this.formats.isEmpty()) {
            throw new ComponentInitializationException("NameIDFlow Descriptor " + this.getId() + " Should specify one or more formats");
        }
    }
}

