/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.config.AbstractProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAMLProfileConfiguration
extends AbstractProfileConfiguration
implements SAMLProfileConfiguration {
    @Nonnull
    private Predicate<ProfileRequestContext> signedRequestsPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> signResponsesPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> signAssertionsPredicate = Predicates.alwaysFalse();
    @Duration
    @Positive
    private long assertionLifetime = 300000L;
    private boolean includeConditionsNotBefore = true;
    @Nonnull
    @NonnullElements
    private Set<String> assertionAudiences = Collections.emptySet();

    public AbstractSAMLProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getSignAssertions() {
        return this.signAssertionsPredicate;
    }

    public void setSignAssertions(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if assertions should be signed cannot be null");
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getSignRequests() {
        return this.signedRequestsPredicate;
    }

    public void setSignRequests(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signedRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if received requests should be signed cannot be null");
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getSignResponses() {
        return this.signResponsesPredicate;
    }

    public void setSignResponses(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signResponsesPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if responses should be signed cannot be null");
    }

    @Override
    @Positive
    public long getAssertionLifetime() {
        return this.assertionLifetime;
    }

    public void setAssertionLifetime(@Duration @Positive long lifetime) {
        this.assertionLifetime = Constraint.isGreaterThan((long)0L, (long)lifetime, (String)"Assertion lifetime must be greater than 0");
    }

    @Override
    public boolean includeConditionsNotBefore() {
        return this.includeConditionsNotBefore;
    }

    public void setIncludeConditionsNotBefore(boolean include) {
        this.includeConditionsNotBefore = include;
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getAdditionalAudiencesForAssertion() {
        return ImmutableSet.copyOf(this.assertionAudiences);
    }

    public void setAdditionalAudienceForAssertion(@Nonnull @NonnullElements Collection<String> audiences) {
        LoggerFactory.getLogger(AbstractSAMLProfileConfiguration.class).warn("Use of deprecated property name 'additionalAudienceForAssertion', please correct to 'additionalAudiencesForAssertion'");
        this.setAdditionalAudiencesForAssertion(audiences);
    }

    public void setAdditionalAudiencesForAssertion(@Nonnull @NonnullElements Collection<String> audiences) {
        if (audiences == null || audiences.isEmpty()) {
            this.assertionAudiences = Collections.emptySet();
            return;
        }
        this.assertionAudiences = new HashSet<String>();
        for (String audience : audiences) {
            String trimmedAudience = StringSupport.trimOrNull((String)audience);
            if (trimmedAudience == null) continue;
            this.assertionAudiences.add(trimmedAudience);
        }
    }
}

