/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class BasicSAMLArtifactConfiguration
implements SAMLArtifactConfiguration {
    @Nullable
    private byte[] artifactType;
    @Nullable
    private String artifactResolutionURL;
    @Nullable
    private Integer artifactResolutionIndex;

    @Override
    @Nullable
    public byte[] getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(@Nullable Integer type) {
        if (type == null) {
            this.artifactType = null;
        } else {
            if (type <= 0) {
                throw new ConstraintViolationException("Artifact type code must be positive");
            }
            if (type > Short.MAX_VALUE) {
                throw new ConstraintViolationException("Artifact type code must fit in two bytes");
            }
            byte[] typeCode = ByteBuffer.allocate(4).putInt(type).array();
            this.artifactType = new byte[2];
            this.artifactType[0] = typeCode[2];
            this.artifactType[1] = typeCode[3];
        }
    }

    @Override
    @Nullable
    public String getArtifactResolutionServiceURL() {
        return this.artifactResolutionURL;
    }

    public void setArtifactResolutionServiceURL(@Nullable String url) {
        this.artifactResolutionURL = StringSupport.trimOrNull((String)url);
    }

    @Override
    @Nullable
    public Integer getArtifactResolutionServiceIndex() {
        return this.artifactResolutionIndex;
    }

    public void setArtifactResolutionServiceIndex(@Nullable Integer index) {
        this.artifactResolutionIndex = index;
    }
}

