/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactAwareProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.AbstractSAML2ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class BrowserSSOProfileConfiguration
extends AbstractSAML2ProfileConfiguration
implements SAMLArtifactAwareProfileConfiguration,
AuthenticationProfileConfiguration {
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml2/sso/browser";
    @Nullable
    private SAMLArtifactConfiguration artifactConfig;
    private boolean resolveAttributes;
    private boolean includeAttributeStatement;
    private boolean skipEndpointValidationWhenSigned;
    @Duration
    @NonNegative
    private long maximumSPSessionLifetime;
    @Nonnull
    private Predicate<ProfileRequestContext> allowDelegationPredicate;
    private Boolean allowingDelegation;
    @NonNegative
    private long maximumTokenDelegationChainLength;
    @Nonnull
    @NonnullElements
    private List<AuthnContextClassRefPrincipal> defaultAuthenticationContexts;
    @Nonnull
    @NonnullElements
    private Set<String> authenticationFlows;
    @Nonnull
    @NonnullElements
    private List<String> postAuthenticationFlows;
    @Nonnull
    @NonnullElements
    private List<String> nameIDFormatPrecedence;

    public BrowserSSOProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected BrowserSSOProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponses((Predicate<ProfileRequestContext>)Predicates.alwaysTrue());
        this.setEncryptAssertions((Predicate<ProfileRequestContext>)Predicates.alwaysTrue());
        this.resolveAttributes = true;
        this.includeAttributeStatement = true;
        this.skipEndpointValidationWhenSigned = false;
        this.maximumSPSessionLifetime = 0L;
        this.allowingDelegation = null;
        this.maximumTokenDelegationChainLength = 1L;
        this.allowDelegationPredicate = Predicates.alwaysFalse();
        this.defaultAuthenticationContexts = Collections.emptyList();
        this.authenticationFlows = Collections.emptySet();
        this.postAuthenticationFlows = Collections.emptyList();
        this.nameIDFormatPrecedence = Collections.emptyList();
    }

    @Override
    @Nullable
    public SAMLArtifactConfiguration getArtifactConfiguration() {
        return this.artifactConfig;
    }

    public void setArtifactConfiguration(@Nullable SAMLArtifactConfiguration config) {
        this.artifactConfig = config;
    }

    public boolean resolveAttributes() {
        return this.resolveAttributes;
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributes = flag;
    }

    public boolean includeAttributeStatement() {
        return this.includeAttributeStatement;
    }

    public void setIncludeAttributeStatement(boolean include) {
        this.includeAttributeStatement = include;
    }

    public boolean skipEndpointValidationWhenSigned() {
        return this.skipEndpointValidationWhenSigned;
    }

    public void setSkipEndpointValidationWhenSigned(boolean skip) {
        this.skipEndpointValidationWhenSigned = skip;
    }

    @NonNegative
    public long getMaximumSPSessionLifetime() {
        return this.maximumSPSessionLifetime;
    }

    public void setMaximumSPSessionLifetime(@Duration @NonNegative long lifetime) {
        this.maximumSPSessionLifetime = Constraint.isGreaterThanOrEqual((long)0L, (long)lifetime, (String)"Maximum SP session lifetime must be greater than or equal to 0");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getAllowDelegation() {
        return this.allowDelegationPredicate;
    }

    public void setAllowDelegation(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.allowDelegationPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Allow delegation predicate may not be null");
    }

    @Deprecated
    public Boolean getAllowingDelegation() {
        return this.allowingDelegation;
    }

    @Deprecated
    public boolean isAllowingDelegation() {
        if (this.allowingDelegation != null) {
            return this.allowingDelegation;
        }
        return false;
    }

    @Deprecated
    public void setAllowingDelegation(Boolean isAllowed) {
        this.allowingDelegation = isAllowed;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods() {
        return ImmutableList.copyOf(this.defaultAuthenticationContexts);
    }

    public long getMaximumTokenDelegationChainLength() {
        return this.maximumTokenDelegationChainLength;
    }

    public void setMaximumTokenDelegationChainLength(@NonNegative long length) {
        this.maximumTokenDelegationChainLength = Constraint.isGreaterThanOrEqual((long)0L, (long)length, (String)"Delegation chain length must be greater than or equal to 0");
    }

    public void setDefaultAuthenticationMethods(@Nonnull @NonnullElements List<AuthnContextClassRefPrincipal> contexts) {
        Constraint.isNotNull(contexts, (String)"List of contexts cannot be null");
        this.defaultAuthenticationContexts = new ArrayList<AuthnContextClassRefPrincipal>(Collections2.filter(contexts, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows() {
        return ImmutableSet.copyOf(this.authenticationFlows);
    }

    public void setAuthenticationFlows(@Nonnull @NonnullElements Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.authenticationFlows = new HashSet<String>(StringSupport.normalizeStringCollection(flows));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows() {
        return this.postAuthenticationFlows;
    }

    public void setPostAuthenticationFlows(@Nonnull @NonnullElements Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.postAuthenticationFlows = new ArrayList<String>(StringSupport.normalizeStringCollection(flows));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence() {
        return ImmutableList.copyOf(this.nameIDFormatPrecedence);
    }

    public void setNameIDFormatPrecedence(@Nonnull @NonnullElements List<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedence = new ArrayList<String>(StringSupport.normalizeStringCollection(formats));
    }
}

