/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.w3c.dom.Node;

public class SAML2SPSession
extends BasicSPSession {
    @Nonnull
    private final NameID nameID;
    @Nonnull
    @NotEmpty
    private final String sessionIndex;

    public SAML2SPSession(@Nonnull @NotEmpty String id, @Duration @Positive long creation, @Duration @Positive long expiration, @Nonnull NameID assertedNameID, @Nonnull @NotEmpty String assertedIndex) {
        super(id, creation, expiration);
        this.nameID = (NameID)Constraint.isNotNull((Object)assertedNameID, (String)"NameID cannot be null");
        this.sessionIndex = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)assertedIndex), (String)"SessionIndex cannot be null or empty");
    }

    @Nonnull
    public NameID getNameID() {
        return this.nameID;
    }

    @Nonnull
    @NotEmpty
    public String getSessionIndex() {
        return this.sessionIndex;
    }

    @Nullable
    public String getSPSessionKey() {
        return this.nameID.getValue();
    }

    public int hashCode() {
        return (this.getId() + '!' + this.nameID.getValue() + '!' + this.sessionIndex).hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof SAML2SPSession) {
            NameID n1 = ((SAML2SPSession)((Object)obj)).getNameID();
            NameID n2 = this.nameID;
            if (n1 != null && n2 != null && Objects.equals(n1.getValue(), n2.getValue()) && SAML2ObjectSupport.areNameIDFormatsEquivalent((String)n1.getFormat(), (String)n2.getFormat()) && Objects.equals(n1.getNameQualifier(), n2.getNameQualifier()) && Objects.equals(n1.getSPNameQualifier(), n2.getSPNameQualifier())) {
                return Objects.equals(this.getSessionIndex(), ((SAML2SPSession)((Object)obj)).getSessionIndex());
            }
        }
        return false;
    }

    public String toString() {
        try {
            return MoreObjects.toStringHelper((Object)((Object)this)).add("NameID", (Object)SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)this.nameID))).add("SessionIndex", (Object)this.sessionIndex).toString();
        }
        catch (MarshallingException e) {
            throw new IllegalArgumentException("Error marshalling NameID", e);
        }
    }
}

