/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAMLAttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.SAML1AttributeTranscoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAML1AttributeTranscoder<EncodedType extends IdPAttributeValue>
extends AbstractSAMLAttributeTranscoder<AttributeDesignator, EncodedType>
implements SAML1AttributeTranscoder<EncodedType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAML1AttributeTranscoder.class);
    @Nonnull
    private final SAMLObjectBuilder<Attribute> attributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Attribute.TYPE_NAME);
    @Nonnull
    private final SAMLObjectBuilder<AttributeDesignator> designatorBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AttributeDesignator.TYPE_NAME);

    @Nonnull
    public Class<AttributeDesignator> getEncodedType() {
        return AttributeDesignator.class;
    }

    @Nullable
    public String getEncodedName(@Nonnull TranscodingRule rule) {
        try {
            return new NamingFunction().apply(this.buildAttribute((ProfileRequestContext)null, (IdPAttribute)null, (Class<? extends AttributeDesignator>)AttributeDesignator.class, rule, Collections.emptyList()));
        }
        catch (AttributeEncodingException e) {
            return null;
        }
    }

    @Override
    @Nonnull
    protected AttributeDesignator buildAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nullable IdPAttribute attribute, @Nonnull Class<? extends AttributeDesignator> to, @Nonnull TranscodingRule rule, @Nonnull @NonnullElements List<XMLObject> attributeValues) throws AttributeEncodingException {
        AttributeDesignator samlAttribute;
        if (attribute != null && !attribute.getValues().isEmpty() && attributeValues.isEmpty()) {
            throw new AttributeEncodingException("Failed to encode any values for attribute " + attribute.getId());
        }
        String name = (String)rule.get("saml1.name", String.class);
        if (Strings.isNullOrEmpty((String)name)) {
            throw new AttributeEncodingException("Required transcoder property 'saml1.name' not found");
        }
        if (to.equals(Attribute.class)) {
            if (attributeValues.isEmpty()) {
                throw new AttributeEncodingException("Unable to encode a SAML 1 Attribute with no values");
            }
            samlAttribute = (AttributeDesignator)this.attributeBuilder.buildObject();
            ((Attribute)samlAttribute).getAttributeValues().addAll(attributeValues);
        } else if (to.equals(AttributeDesignator.class)) {
            samlAttribute = (AttributeDesignator)this.designatorBuilder.buildObject();
            if (!attributeValues.isEmpty()) {
                this.log.warn("Lossy conversion to AttributeDesignator");
            }
        } else {
            throw new AttributeEncodingException("Unsupported target object type: " + to.getName());
        }
        samlAttribute.setAttributeName(name);
        samlAttribute.setAttributeNamespace((String)rule.getOrDefault("saml1.namespace", String.class, (Object)"urn:mace:shibboleth:1.0:attributeNamespace:uri"));
        return samlAttribute;
    }

    @Override
    @Nonnull
    protected IdPAttribute buildIdPAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nonnull AttributeDesignator attribute, @Nonnull TranscodingRule rule, @Nonnull @NonnullElements List<IdPAttributeValue> attributeValues) throws AttributeDecodingException {
        IdPRequestedAttribute idpAttribute;
        String id = (String)rule.get("id", String.class);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new AttributeDecodingException("Required transcoder property 'id' not found");
        }
        if (attribute instanceof Attribute) {
            if (!((Attribute)attribute).getAttributeValues().isEmpty() && attributeValues.isEmpty()) {
                throw new AttributeDecodingException("Failed to decode any values for attribute " + attribute.getAttributeName());
            }
            idpAttribute = new IdPAttribute(id);
        } else {
            idpAttribute = new IdPRequestedAttribute(id);
        }
        idpAttribute.setValues(attributeValues);
        return idpAttribute;
    }

    @Override
    @Nonnull
    protected Iterable<XMLObject> getValues(@Nonnull AttributeDesignator input) {
        return input instanceof Attribute ? ((Attribute)input).getAttributeValues() : Collections.emptyList();
    }

    public static class NamingFunction
    implements Function<AttributeDesignator, String> {
        @Override
        @Nullable
        public String apply(@Nullable AttributeDesignator input) {
            if (input == null || input.getAttributeName() == null || input.getAttributeNamespace() == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("SAML1:{").append(input.getAttributeNamespace()).append('}').append(input.getAttributeName());
            return builder.toString();
        }
    }
}

