/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.saml.xmlobject.ScopedValue;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SAMLEncoderSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(SAMLEncoderSupport.class);

    private SAMLEncoderSupport() {
    }

    @Nullable
    public static XMLObject encodeStringValue(@Nonnull IdPAttribute attribute, @Nonnull QName attributeValueElementName, @Nullable String value, boolean withType) {
        Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        Constraint.isNotNull((Object)attributeValueElementName, (String)"Attribute Element Name cannot be null");
        if (Strings.isNullOrEmpty((String)value)) {
            LOG.debug("Skipping empty value for attribute {}", (Object)attribute.getId());
            return null;
        }
        LOG.debug("Encoding value {} of attribute {}", (Object)value, (Object)attribute.getId());
        if (withType) {
            XMLObjectBuilder stringBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSString.TYPE_NAME);
            XSString samlAttributeValue = (XSString)stringBuilder.buildObject(attributeValueElementName, XSString.TYPE_NAME);
            samlAttributeValue.setValue(value);
            return samlAttributeValue;
        }
        XMLObjectBuilder anyBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSAny.TYPE_NAME);
        XSAny samlAttributeValue = (XSAny)anyBuilder.buildObject(attributeValueElementName);
        samlAttributeValue.setTextContent(value);
        return samlAttributeValue;
    }

    @Nullable
    public static XMLObject encodeByteArrayValue(@Nonnull IdPAttribute attribute, @Nonnull QName attributeValueElementName, @Nullable byte[] value, boolean withType) throws EncodingException {
        Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        Constraint.isNotNull((Object)attributeValueElementName, (String)"Attribute Element Name cannot be null");
        if (value == null || value.length == 0) {
            LOG.debug("Skipping empty value for attribute {}", (Object)attribute.getId());
            return null;
        }
        if (withType) {
            XMLObjectBuilder binaryBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSBase64Binary.TYPE_NAME);
            XSBase64Binary samlAttributeValue = (XSBase64Binary)binaryBuilder.buildObject(attributeValueElementName, XSBase64Binary.TYPE_NAME);
            samlAttributeValue.setValue(Base64Support.encode((byte[])value, (boolean)false));
            return samlAttributeValue;
        }
        XMLObjectBuilder anyBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSAny.TYPE_NAME);
        XSAny samlAttributeValue = (XSAny)anyBuilder.buildObject(attributeValueElementName);
        samlAttributeValue.setTextContent(Base64Support.encode((byte[])value, (boolean)false));
        return samlAttributeValue;
    }

    @Nullable
    public static XMLObject encodeXMLObjectValue(@Nonnull IdPAttribute attribute, @Nonnull QName attributeValueElementName, @Nullable XMLObject value) {
        if (value == null) {
            LOG.debug("Skipping empty value for attribute {}", (Object)attribute.getId());
            return null;
        }
        Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        Constraint.isNotNull((Object)attributeValueElementName, (String)"Attribute Element Name cannot be null");
        XMLObjectBuilder attributeValueBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSAny.TYPE_NAME);
        XSAny samlAttributeValue = (XSAny)attributeValueBuilder.buildObject(attributeValueElementName);
        samlAttributeValue.getUnknownXMLObjects().add(value);
        return samlAttributeValue;
    }

    public static XMLObject encodeScopedStringValueAttribute(@Nonnull IdPAttribute attribute, @Nonnull QName attributeValueElementName, @Nullable ScopedStringAttributeValue value, @Nonnull @NotEmpty String scopeAttributeName, boolean withType) {
        Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        Constraint.isNotNull((Object)attributeValueElementName, (String)"Attribute Element Name cannot be null");
        Constraint.isNotNull((Object)scopeAttributeName, (String)"Scope Attribute Name cannot be null");
        if (null == value || Strings.isNullOrEmpty((String)value.getScope()) || Strings.isNullOrEmpty((String)value.getValue())) {
            LOG.debug("Skipping empty value (or contents) for attribute {}", (Object)attribute.getId());
            return null;
        }
        XMLObjectBuilder scopedValueBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ScopedValue.TYPE_NAME);
        ScopedValue scopedValue = withType ? (ScopedValue)scopedValueBuilder.buildObject(attributeValueElementName, ScopedValue.TYPE_NAME) : (ScopedValue)scopedValueBuilder.buildObject(attributeValueElementName);
        scopedValue.setScopeAttributeName(scopeAttributeName);
        scopedValue.setScope(value.getScope());
        scopedValue.setValue(value.getValue());
        return scopedValue;
    }

    public static XMLObject encodeScopedStringValueInline(@Nonnull IdPAttribute attribute, @Nonnull QName attributeValueElementName, @Nullable ScopedStringAttributeValue value, @Nonnull String scopeDelimiter, boolean withType) {
        Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        Constraint.isNotNull((Object)attributeValueElementName, (String)"Attribute Element Name cannot be null");
        Constraint.isNotNull((Object)scopeDelimiter, (String)"Scope delimiter cannot be null");
        if (null == value || Strings.isNullOrEmpty((String)value.getScope()) || Strings.isNullOrEmpty((String)value.getValue())) {
            LOG.debug("Skipping empty value (or contents) for attribute {}", (Object)attribute.getId());
            return null;
        }
        StringBuilder builder = new StringBuilder(value.getValue()).append(scopeDelimiter).append(value.getScope());
        return SAMLEncoderSupport.encodeStringValue(attribute, attributeValueElementName, builder.toString(), withType);
    }
}

